/*
 * Decompiled with CFR 0.152.
 */
package com.stonikbyte.projectdocs.bulkupload.cli;

import com.stonikbyte.projectdocs.bulkupload.cli.DocTitleOperation;
import com.stonikbyte.projectdocs.bulkupload.cli.InvalidLoginConfiguration;
import com.stonikbyte.projectdocs.bulkupload.common.util.UploadResultsLogger;
import com.stonikbyte.projectdocs.bulkupload.common.ws.ApplicationSettings;
import com.stonikbyte.projectdocs.bulkupload.common.ws.BasicUploadParams;
import com.stonikbyte.projectdocs.bulkupload.common.ws.FileUploadWsMethods;
import java.io.File;
import java.net.UnknownHostException;
import javax.net.ssl.SSLException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.impl.client.DefaultHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.teodorbaciu.commons.client.ws.exceptions.InvalidLoginCredentialsException;
import ro.teodorbaciu.commons.client.ws.exceptions.MaxFailedLoginsExceededException;
import ro.teodorbaciu.commons.client.ws.progress.WriteListener;

public class Application {
    private static final Logger generalLogger = LoggerFactory.getLogger(Application.class);
    public static final String SSL_CERTIFICATE_ERROR_MESSAGE = "The JIRA server's security certificate is not trusted by the Java Runtime Enviroment. To ignore this error, please set the 'jira.ignore.ssl.cerficate.errors' to 1  in the 'app.properties' configuration file. However, before ignoring these type of errors, please consult with your network administrator";
    public static final String ERROR_MESSAGE_API_VERSION_MISMATCH = "Cannot upload the file because the current installation of the CLI Uploader is not compatible with your Documents Jira add-on.\nPlease use a CLI Uploader version that is compatible with the upload API version %s\nFor more information, please check the online documentation for the StonikByte Documents add-on.";
    private static final UploadResultsLogger uploadResultsLogger = new UploadResultsLogger();
    private FileUploadWsMethods fileUploadMethodsWs;
    private ApplicationSettings appProperties;

    protected void initialize() throws Exception {
        String basedir = System.getProperty("basedir");
        if (StringUtils.isBlank((String)basedir)) {
            throw new IllegalArgumentException("basedir is not specified");
        }
        System.out.println("app basedir=" + basedir);
        int indexOfAditionalChars = basedir.lastIndexOf("\\\\..");
        if (indexOfAditionalChars == -1) {
            indexOfAditionalChars = basedir.lastIndexOf("/..");
        }
        if (indexOfAditionalChars > 0) {
            basedir = basedir.substring(0, indexOfAditionalChars);
        }
        this.appProperties = new ApplicationSettings("/app.properties", basedir);
        this.appProperties.readConfiguration();
        if (!this.appProperties.isValidLoginInfo()) {
            throw new InvalidLoginConfiguration("not all fields from the app.properties files are specified");
        }
        this.fileUploadMethodsWs = new FileUploadWsMethods(this.appProperties);
        DefaultHttpClient httpClient = new DefaultHttpClient();
        this.fileUploadMethodsWs.setWsHttpClient(httpClient);
        if (this.appProperties.isIgnoreSSLCertficateErrors()) {
            this.fileUploadMethodsWs.setAllowUntruestedHttpsServer(true);
        }
        this.fileUploadMethodsWs.authenticate();
    }

    public String checkUploadFileSize(String filePath) throws Exception {
        generalLogger.debug("getting maximum file upload size...");
        Long sizeInMegabytes = this.fileUploadMethodsWs.getMaximumUploadSize();
        long sizeInBytes = sizeInMegabytes * 1024L * 1024L;
        generalLogger.debug("done getting maximum upload size");
        File fileToUpload = new File(filePath);
        if (fileToUpload.length() > sizeInBytes) {
            String errorMessage = "The size of the file exceeds the maximum allowed of " + sizeInMegabytes + " MB";
            return errorMessage;
        }
        return null;
    }

    protected void uploadFile(BasicUploadParams params) throws Exception {
        generalLogger.debug("Uploading file " + params.filePath);
        int maxTitleChars = 255;
        String documentTitle = params.documentTitle;
        DocTitleOperation opCleaned = Application.cleanDocumentTitle(documentTitle);
        DocTitleOperation opShortened = Application.shortenDocumentTitle(opCleaned.documentTitle, maxTitleChars);
        params.documentTitle = opShortened.documentTitle;
        params.isUpload = true;
        if (params.destRelativePath != null) {
            params.destRelativePath = params.destRelativePath.replace("/", "-->");
        }
        File file = new File(params.filePath);
        String originalCRC = "" + FileUtils.checksumCRC32((File)file);
        UploadWriteListener listener = new UploadWriteListener(file);
        String documentKey = this.fileUploadMethodsWs.sendFile(originalCRC, params, (WriteListener)listener).getResult().toString();
        String message = "Success: created document with key " + documentKey + " for file [" + params.filePath + "]";
        if (opCleaned.changed) {
            message = message + "- single and/or double quotes were removed from the document title";
        }
        if (opShortened.changed) {
            message = message + "- the document title was shortened to be less than " + maxTitleChars;
        }
        generalLogger.info("\n" + message);
        uploadResultsLogger.log(message);
    }

    protected static DocTitleOperation cleanDocumentTitle(String documentTitle) {
        DocTitleOperation result = new DocTitleOperation();
        result.documentTitle = documentTitle;
        if (documentTitle.contains("\"")) {
            result.documentTitle = StringUtils.remove((String)documentTitle, (String)"\"");
            result.changed = true;
        }
        if (result.documentTitle.contains("'")) {
            result.documentTitle = StringUtils.remove((String)result.documentTitle, (String)"'");
            result.changed = true;
        }
        return result;
    }

    protected static DocTitleOperation shortenDocumentTitle(String documentTitle, int maxTitleChars) {
        DocTitleOperation result = new DocTitleOperation();
        result.documentTitle = documentTitle;
        if (documentTitle.length() > maxTitleChars) {
            result.documentTitle = StringUtils.abbreviate((String)documentTitle, (int)maxTitleChars);
            result.changed = true;
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        String errorMessage = null;
        try {
            BasicUploadParams params = Application.checkParameters(args);
            if (!params.paramsValid) {
                return;
            }
            Application app = new Application();
            app.initialize();
            String uploadAPIVersion = app.getServerAPIVersion();
            if (uploadAPIVersion.equals("2.0")) {
                String uploadSizeExceedsErrorMessage = app.checkUploadFileSize(params.filePath);
                if (uploadSizeExceedsErrorMessage != null) {
                    errorMessage = uploadSizeExceedsErrorMessage;
                } else {
                    app.uploadFile(params);
                }
            } else {
                errorMessage = String.format(ERROR_MESSAGE_API_VERSION_MISMATCH, uploadAPIVersion);
            }
        }
        catch (InvalidLoginCredentialsException ile) {
            errorMessage = "The specified login credentials are not valid. Please check the username/password combination from the app.properties file.";
        }
        catch (MaxFailedLoginsExceededException mfe) {
            errorMessage = "You have exceeded the maximum number of failed logins that are allowed by the JIRA server. To solve this error, please log in to your JIRA account using your browser.";
        }
        catch (InvalidLoginConfiguration ilc) {
            errorMessage = "The settings from the app.properties file are not valid. Please make sure all the required information is specified.";
        }
        catch (UnknownHostException uhe) {
            errorMessage = "Could not connect to host \"" + uhe.getMessage() + "\". Please check the URL of the server.";
        }
        catch (SSLException se) {
            errorMessage = SSL_CERTIFICATE_ERROR_MESSAGE;
        }
        catch (Exception e) {
            generalLogger.error("", (Throwable)e);
            errorMessage = "Error processing the request. " + e.getMessage();
        }
        if (errorMessage != null) {
            String logMessage;
            if (args.length >= 3) {
                logMessage = "Error: could not process file [" + args[2] + "]. " + errorMessage;
                generalLogger.error(logMessage);
                uploadResultsLogger.log(logMessage);
            } else {
                logMessage = "Error: could not process file. " + errorMessage;
                generalLogger.info(logMessage);
            }
        }
    }

    protected String getServerAPIVersion() throws Exception {
        return this.fileUploadMethodsWs.getUploadModuleVersion();
    }

    static BasicUploadParams checkParameters(String[] args) {
        BasicUploadParams result = new BasicUploadParams();
        if (args.length < 3) {
            generalLogger.info("Error: please specify the required parameters in quotes\n\tParam 1 (Required): the key of the destination folder\n\tParam 2 (Required): the title of the document\n\tParam 3 (Required): the full path of the file to upload\n\tParam 4 (Optional): the folders structure in the destination folder where the document is created\nExample: \"111\" \"Document title\" \"C:\\path-to-file.ext\" \"SubFolder1/SubFolder2\"");
            result.paramsValid = false;
            return result;
        }
        String folderKey = args[0];
        if (StringUtils.isEmpty((String)folderKey)) {
            generalLogger.info("Error: Please specify Param 1 (the key of the destination folder).");
            result.paramsValid = false;
            return result;
        }
        try {
            Long.parseLong(folderKey);
        }
        catch (NumberFormatException nfe) {
            generalLogger.info("Error: Param 1 (the key of the destination folder) must be an integer number.");
            result.paramsValid = false;
            return result;
        }
        result.destFolderKey = folderKey;
        String documentTitle = args[1];
        if (StringUtils.isEmpty((String)documentTitle)) {
            generalLogger.info("Error: Please specify Param 2 (the document title).");
            result.paramsValid = false;
            return result;
        }
        result.documentTitle = documentTitle;
        String filePath = args[2];
        File fileToUpload = new File(filePath);
        if (!fileToUpload.exists()) {
            generalLogger.info("Error: the specified file '" + filePath + "' does not exist.");
            result.paramsValid = false;
            return result;
        }
        if (fileToUpload.isDirectory()) {
            generalLogger.info("Error: you cannot upload whole directories. The specified file \"" + filePath + "\" is a directory or drive.");
            result.paramsValid = false;
            return result;
        }
        result.filePath = filePath;
        if (args.length >= 4) {
            result.destRelativePath = args[3];
            if (result.destRelativePath.startsWith("/")) {
                generalLogger.info("Error: please make sure the destination relative path does not start with a trailing slash character '/'.");
                result.paramsValid = false;
                return result;
            }
            if (result.destRelativePath.endsWith("/")) {
                generalLogger.info("Error: please make sure the destination relative path does not end with a trailing slash character '/'.");
                result.paramsValid = false;
                return result;
            }
            if (result.destRelativePath.contains("//")) {
                generalLogger.info("Error: please make sure the destination relative path does not contain any '//' sections.");
                result.paramsValid = false;
                return result;
            }
            if (result.destRelativePath.length() > 255) {
                generalLogger.info("Error: please make sure the destination relative path is less than 255 characters.");
                result.paramsValid = false;
                return result;
            }
            if (result.destRelativePath.contains("'")) {
                generalLogger.info("Error: please make sure the destination relative path does not contain any single quote character.");
                result.paramsValid = false;
                return result;
            }
            if (result.destRelativePath.contains("\"")) {
                generalLogger.info("Error: please make sure the destination relative path does not contain any double quote character.");
                result.paramsValid = false;
                return result;
            }
        }
        result.paramsValid = true;
        return result;
    }

    class UploadWriteListener
    implements WriteListener {
        private double fileSize;

        public UploadWriteListener(File file) {
            this.fileSize = file.length();
        }

        public void registerWrite(long numBytes) {
            double dPercentage = (double)numBytes / this.fileSize * 100.0;
            int percentage = (int)dPercentage;
            if (percentage > 100) {
                percentage = 100;
            }
            this.printProgBar(percentage);
        }

        public void printProgBar(int percent) {
            StringBuilder bar = new StringBuilder("[");
            for (int i = 0; i < 50; ++i) {
                if (i < percent / 2) {
                    bar.append("=");
                    continue;
                }
                if (i == percent / 2) {
                    bar.append(">");
                    continue;
                }
                bar.append(" ");
            }
            bar.append("]   " + percent + "%     ");
            System.out.print("\r" + bar.toString());
        }
    }
}

