/*
 * Decompiled with CFR 0.152.
 */
package ro.teodorbaciu.commons.client.ws;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.cookie.Cookie;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.teodorbaciu.commons.client.ws.exceptions.AuthorizationRequiredException;
import ro.teodorbaciu.commons.client.ws.exceptions.InvalidLoginCredentialsException;
import ro.teodorbaciu.commons.client.ws.exceptions.InvalidWsParamsException;
import ro.teodorbaciu.commons.client.ws.exceptions.MaxFailedLoginsExceededException;
import ro.teodorbaciu.commons.client.ws.exceptions.OperationForbiddenException;
import ro.teodorbaciu.commons.client.ws.exceptions.ReAuthenticationException;
import ro.teodorbaciu.commons.client.ws.progress.MultipartEntityWithProgressMonitoring;
import ro.teodorbaciu.commons.client.ws.progress.WriteListener;
import ro.teodorbaciu.commons.client.ws.util.WebClientDevWrapper;

public abstract class BaseWsMethods {
    private static final Logger log = LoggerFactory.getLogger(BaseWsMethods.class);
    protected String webserviceHost;
    protected DefaultHttpClient wsHttpClient;
    protected HttpContext httpContext;
    protected boolean allowUntruestedHttpsServer;
    protected String authenticatedWebserviceUri = "/aws";
    protected String publicWebserviceUri = "/pws";
    private HttpUriRequest currentRequest;

    protected String callPublicWsOperation(String moduleName, String op, List<NameValuePair> wsParamsList) throws AuthorizationRequiredException, OperationForbiddenException, UnsupportedEncodingException, ClientProtocolException, IOException {
        String targetUrl = String.valueOf(this.webserviceHost) + this.publicWebserviceUri;
        try {
            String string = this.callServer(moduleName, op, targetUrl, wsParamsList);
            return string;
        }
        finally {
            this.currentRequest = null;
        }
    }

    public byte[] executeHttpGet(String uri) throws Exception {
        String targetUrl = String.valueOf(this.webserviceHost) + uri;
        HttpGet get = new HttpGet(targetUrl);
        HttpResponse response = this.wsHttpClient.execute((HttpUriRequest)get);
        int statusCode = response.getStatusLine().getStatusCode();
        String reasonPhrase = response.getStatusLine().getReasonPhrase();
        if (statusCode == 401) {
            get.abort();
            throw new AuthorizationRequiredException("You need to authenticate first !");
        }
        if (statusCode == 412) {
            get.abort();
            throw new InvalidWsParamsException("Error calling http get because of invalid parameters ! Server returned: " + reasonPhrase);
        }
        if (statusCode == 403) {
            get.abort();
            throw new OperationForbiddenException("The server refused to execute the specified operation ! Server returned: " + reasonPhrase);
        }
        if (statusCode != 200) {
            get.abort();
            throw new RuntimeException("Could not get http response ! Status:" + statusCode + " Server returned: " + reasonPhrase);
        }
        HttpEntity entity = response.getEntity();
        if (entity == null) {
            throw new RuntimeException("Could not get http response ! Server returned: " + reasonPhrase);
        }
        return EntityUtils.toByteArray((HttpEntity)entity);
    }

    public String callWsOperationMultipartPost(String moduleName, String op, List<NameValuePair> wsParamsList, File fileToUpload, WriteListener writeListener) throws AuthorizationRequiredException, OperationForbiddenException, ReAuthenticationException, UnsupportedEncodingException, ClientProtocolException, IOException {
        String targetUrl = String.valueOf(this.webserviceHost) + this.authenticatedWebserviceUri;
        try {
            String string = this.callServerMultipartPost(moduleName, op, targetUrl, wsParamsList, fileToUpload, writeListener);
            return string;
        }
        catch (AuthorizationRequiredException uae) {
            if (this.reAuthenticate()) {
                String string = this.callServerMultipartPost(moduleName, op, targetUrl, wsParamsList, fileToUpload, writeListener);
                return string;
            }
            throw new ReAuthenticationException("Could not authenticate again for calling multipart ws operation !");
        }
        finally {
            this.currentRequest = null;
        }
    }

    public void cancelCurrentRequest() {
        this.currentRequest.abort();
    }

    protected String callWsOperation(String moduleName, String op, List<NameValuePair> wsParamsList) throws AuthorizationRequiredException, OperationForbiddenException, ReAuthenticationException, UnsupportedEncodingException, ClientProtocolException, IOException {
        String targetUrl = String.valueOf(this.webserviceHost) + this.authenticatedWebserviceUri;
        try {
            String string = this.callServer(moduleName, op, targetUrl, wsParamsList);
            return string;
        }
        catch (AuthorizationRequiredException uae) {
            if (this.reAuthenticate()) {
                String string = this.callServer(moduleName, op, targetUrl, wsParamsList);
                return string;
            }
            throw new ReAuthenticationException("Could not authenticate again for calling ws operation !");
        }
        finally {
            this.currentRequest = null;
        }
    }

    protected abstract List<NameValuePair> getAuthenticationParams();

    protected boolean reAuthenticate() {
        try {
            List<NameValuePair> authParams = this.getAuthenticationParams();
            return this.authenticate(authParams);
        }
        catch (Exception e) {
            log.error("Exception thrown during re-authentication", (Throwable)e);
            return false;
        }
    }

    public boolean authenticate(List<NameValuePair> authenticationParams) throws InvalidLoginCredentialsException, MaxFailedLoginsExceededException, UnsupportedEncodingException, ClientProtocolException, IOException {
        this.httpContext = new BasicHttpContext();
        String targetUrl = String.valueOf(this.webserviceHost) + "/login";
        HttpPost post = new HttpPost(targetUrl);
        ArrayList<Object> paramsList = new ArrayList<Object>();
        paramsList.addAll(authenticationParams);
        paramsList.add(new BasicNameValuePair("only-send-http-response", "true"));
        UrlEncodedFormEntity formEntity = new UrlEncodedFormEntity(paramsList, "UTF-8");
        post.setEntity((HttpEntity)formEntity);
        HttpResponse response = this.wsHttpClient.execute((HttpUriRequest)post, this.httpContext);
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode != 200) {
            post.abort();
            if (statusCode == 401) {
                throw new InvalidLoginCredentialsException("The username/password combination was not valid ");
            }
            return false;
        }
        post.abort();
        return true;
    }

    public Cookie getCookie() {
        CookieStore cookieStore = this.wsHttpClient.getCookieStore();
        if (cookieStore == null) {
            return null;
        }
        List listCookies = cookieStore.getCookies();
        if (listCookies.size() == 0) {
            return null;
        }
        return (Cookie)listCookies.get(listCookies.size() - 1);
    }

    private String callServerMultipartPost(String moduleName, String op, String targetUrl, List<NameValuePair> wsParamsList, File fileToUpload, WriteListener writeListener) throws AuthorizationRequiredException, OperationForbiddenException, UnsupportedEncodingException, ClientProtocolException, IOException {
        if (this.currentRequest != null) {
            throw new RuntimeException("Another webservice request is still executing !");
        }
        String postUrl = String.valueOf(targetUrl) + "?module=" + moduleName + "&op=" + op;
        HttpPost post = new HttpPost(postUrl);
        MultipartEntity reqEntity = null;
        reqEntity = writeListener != null ? new MultipartEntityWithProgressMonitoring(writeListener) : new MultipartEntity();
        for (NameValuePair pair : wsParamsList) {
            reqEntity.addPart(pair.getName(), (ContentBody)new StringBody(pair.getValue()));
        }
        reqEntity.addPart("data", (ContentBody)new FileBody(fileToUpload));
        post.setEntity((HttpEntity)reqEntity);
        return this.processServerPost(post);
    }

    private String processServerPost(HttpPost post) throws IOException, ClientProtocolException, AuthorizationRequiredException, InvalidWsParamsException, OperationForbiddenException {
        this.currentRequest = post;
        HttpResponse response = this.wsHttpClient.execute((HttpUriRequest)post);
        int statusCode = response.getStatusLine().getStatusCode();
        String reasonPhrase = response.getStatusLine().getReasonPhrase();
        if (statusCode == 401) {
            post.abort();
            throw new AuthorizationRequiredException("You need to authenticate first !");
        }
        if (statusCode == 412) {
            post.abort();
            throw new InvalidWsParamsException("Error calling webservice because of invalid parameters ! Server returned: " + reasonPhrase);
        }
        if (statusCode == 403) {
            post.abort();
            throw new OperationForbiddenException("The server refused to execute the specified operation !  Server returned: " + reasonPhrase);
        }
        if (statusCode != 200) {
            post.abort();
            throw new RuntimeException("Could not get webservice response ! Status:" + statusCode + " Server returned: " + reasonPhrase);
        }
        HttpEntity entity = response.getEntity();
        if (entity == null) {
            throw new RuntimeException("Could not get webservice response !  Server returned: " + reasonPhrase);
        }
        return EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
    }

    private String callServer(String moduleName, String op, String targetUrl, List<NameValuePair> wsParamsList) throws AuthorizationRequiredException, OperationForbiddenException, UnsupportedEncodingException, ClientProtocolException, IOException {
        HttpPost post = new HttpPost(targetUrl);
        ArrayList<Object> paramsList = new ArrayList<Object>();
        paramsList.add(new BasicNameValuePair("module", moduleName));
        paramsList.add(new BasicNameValuePair("op", op));
        paramsList.addAll(wsParamsList);
        UrlEncodedFormEntity formEntity = new UrlEncodedFormEntity(paramsList, "UTF-8");
        post.setEntity((HttpEntity)formEntity);
        return this.processServerPost(post);
    }

    public void setWsHttpClient(DefaultHttpClient wsHttpClient) {
        this.wsHttpClient = this.allowUntruestedHttpsServer ? WebClientDevWrapper.wrapClient((HttpClient)wsHttpClient) : wsHttpClient;
    }

    public void setWebserviceHost(String webserviceHost) {
        this.webserviceHost = webserviceHost;
    }

    public String getWebserviceHost() {
        return this.webserviceHost;
    }

    public void setAllowUntruestedHttpsServer(boolean allowUntruestedHttpsServer) {
        this.allowUntruestedHttpsServer = allowUntruestedHttpsServer;
    }

    public String getAuthenticatedWebserviceUri() {
        return this.authenticatedWebserviceUri;
    }

    public void setAuthenticatedWebserviceUri(String authenticatedWebserviceUri) {
        this.authenticatedWebserviceUri = authenticatedWebserviceUri;
    }

    public boolean isAllowUntruestedHttpsServer() {
        return this.allowUntruestedHttpsServer;
    }
}

