/*
 * Decompiled with CFR 0.152.
 */
package com.stonikbyte.projectdocs.bulkupload.common.util;

import com.stonikbyte.jira.plugins.projectdocs.beans.FolderItem;
import com.stonikbyte.jira.plugins.projectdocs.beans.FolderReadingResult;
import com.stonikbyte.jira.plugins.projectdocs.beans.ServerOperationResult;
import java.io.File;

public class Util {
    public static FolderReadingResult readFolderItems(File selectedFolder) {
        FolderReadingResult result = new FolderReadingResult(selectedFolder);
        Util.readFolderItems(result, selectedFolder, selectedFolder);
        return result;
    }

    public static void readFolderItems(FolderReadingResult result, File parentFolder, File selectedFolder) {
        File[] children = parentFolder.listFiles();
        if (children == null) {
            return;
        }
        for (int i = 0; i < children.length; ++i) {
            File file = children[i];
            if (file.isDirectory()) {
                Util.readFolderItems(result, file, selectedFolder);
                continue;
            }
            FolderItem docItem = new FolderItem(file);
            result.add(docItem);
            if (docItem.cleanDocumentTitle()) {
                result.setDocumentTitlesCleaned(true);
            }
            if (docItem.shortenDocumentTitle()) {
                result.setDocumentTitlesShortened(true);
            }
            docItem.computeRelativePath(selectedFolder);
            docItem.computeDisplayRelativePath(selectedFolder);
        }
    }

    public static String getOperationResultMessage(ServerOperationResult operationResult, String filePath) {
        String result;
        String message = "success: %s %s for file [%s]";
        switch (operationResult.getType()) {
            case "sync-created-new-file": {
                result = String.format(message, "file sync: created document with key", operationResult.getResult().toString(), filePath);
                break;
            }
            case "sync-created-new-version": {
                result = String.format(message, "file sync: created new version with version id", operationResult.getResult().toString(), filePath);
                break;
            }
            case "sync-skipped-server-newer": {
                result = String.format(message, "file sync: skipped document (server version is newer)", "", filePath);
                break;
            }
            case "upload-created-new-file": {
                result = String.format(message, "file upload: created document with key", operationResult.getResult().toString(), filePath);
                break;
            }
            case "sync-skipped-more-than-one-document": {
                result = String.format(message, "file sync: skipped document (multiple documents with the same title)", "", filePath);
                break;
            }
            case "sync-skipped-same-contents": {
                result = String.format(message, "file sync: skipped document (same contents)", "", filePath);
                break;
            }
            default: {
                throw new RuntimeException("Unknown operation type " + operationResult.getType());
            }
        }
        return result;
    }
}

