/*
 * Decompiled with CFR 0.152.
 */
package com.stonikbyte.projectdocs.bulkupload.common.ws;

import com.google.gson.reflect.TypeToken;
import com.stonikbyte.jira.plugins.projectdocs.beans.DocumentInfoBean;
import com.stonikbyte.jira.plugins.projectdocs.beans.ServerOperationResult;
import com.stonikbyte.projectdocs.bulkupload.common.ws.ApplicationSettings;
import com.stonikbyte.projectdocs.bulkupload.common.ws.BasicUploadParams;
import com.stonikbyte.projectdocs.bulkupload.common.ws.ProjectDocsBaseWsMethods;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import ro.teodorbaciu.commons.client.ws.progress.WriteListener;
import ro.teodorbaciu.commons.ws.transfer.beans.ObjectWrapper;

public class FileUploadWsMethods
extends ProjectDocsBaseWsMethods {
    public FileUploadWsMethods(ApplicationSettings properties) {
        super(properties);
    }

    public Long getMaximumUploadSize() throws Exception {
        ArrayList listParams = new ArrayList();
        String response = this.callWsOperation("ws-module-upload-services", "get-maximum-file-upload-size", listParams);
        Type wrapperType = new TypeToken<ObjectWrapper<Long>>(){}.getType();
        ObjectWrapper wrapper = (ObjectWrapper)this.getGson().fromJson(response, wrapperType);
        if (!wrapper.isSuccess()) {
            throw new RuntimeException("Could not get maximum upload size: " + wrapper.getErrorMessage());
        }
        return (Long)wrapper.getObject();
    }

    public DocumentInfoBean getDocumentInfo(String idDocument) throws Exception {
        ArrayList<BasicNameValuePair> listParams = new ArrayList<BasicNameValuePair>();
        listParams.add(new BasicNameValuePair("documentKey", idDocument));
        String response = this.callWsOperation("ws-module-upload-services", "get-document-info", listParams);
        Type wrapperType = new TypeToken<ObjectWrapper<DocumentInfoBean>>(){}.getType();
        ObjectWrapper wrapper = (ObjectWrapper)this.getGson().fromJson(response, wrapperType);
        if (!wrapper.isSuccess()) {
            throw new RuntimeException("Could not get document info: " + wrapper.getErrorMessage());
        }
        return (DocumentInfoBean)wrapper.getObject();
    }

    public String getUploadModuleVersion() throws Exception {
        ArrayList listParams = new ArrayList();
        String response = this.callWsOperation("ws-module-upload-services", "ws-op-get-upload-module-version", listParams);
        Type wrapperType = new TypeToken<ObjectWrapper<String>>(){}.getType();
        ObjectWrapper wrapper = (ObjectWrapper)this.getGson().fromJson(response, wrapperType);
        if (!wrapper.isSuccess()) {
            throw new RuntimeException(wrapper.getErrorMessage());
        }
        return (String)wrapper.getObject();
    }

    public boolean checkUploadRights(String idDestinationFolder) throws Exception {
        ArrayList<BasicNameValuePair> listParams = new ArrayList<BasicNameValuePair>();
        listParams.add(new BasicNameValuePair("id-destination-folder", idDestinationFolder));
        String response = this.callWsOperation("ws-module-upload-services", "ws-op-check-upload-rights", listParams);
        Type wrapperType = new TypeToken<ObjectWrapper<Boolean>>(){}.getType();
        ObjectWrapper wrapper = (ObjectWrapper)this.getGson().fromJson(response, wrapperType);
        if (!wrapper.isSuccess()) {
            throw new RuntimeException(wrapper.getErrorMessage());
        }
        return (Boolean)wrapper.getObject();
    }

    public ServerOperationResult sendFile(String originalFileCrc, BasicUploadParams params, WriteListener writeListener) throws Exception {
        ArrayList<BasicNameValuePair> listParams = new ArrayList<BasicNameValuePair>();
        listParams.add(new BasicNameValuePair("destination-folder-key", params.destFolderKey));
        listParams.add(new BasicNameValuePair("document-title", Base64.encodeBase64String((byte[])params.documentTitle.getBytes("UTF-8"))));
        File fileToUpload = new File(params.filePath);
        listParams.add(new BasicNameValuePair("original-filename", Base64.encodeBase64String((byte[])fileToUpload.getName().getBytes("UTF-8"))));
        listParams.add(new BasicNameValuePair("original-file-crc", originalFileCrc));
        if (!StringUtils.isEmpty((String)params.destRelativePath)) {
            listParams.add(new BasicNameValuePair("dest-relative-path", Base64.encodeBase64String((byte[])params.destRelativePath.getBytes("UTF-8"))));
        }
        if (!params.isUpload) {
            listParams.add(new BasicNameValuePair("last-modified", Long.toString(params.lastModified)));
        }
        String wsOpName = params.isUpload ? "ws-op-upload-file" : "ws-op-sync-file";
        String response = this.callWsOperationMultipartPost("ws-module-upload-services", wsOpName, listParams, new File(params.filePath), writeListener);
        Type wrapperType = new TypeToken<ObjectWrapper<ServerOperationResult>>(){}.getType();
        ObjectWrapper wrapper = (ObjectWrapper)this.getGson().fromJson(response, wrapperType);
        if (!wrapper.isSuccess()) {
            throw new RuntimeException(wrapper.getErrorMessage());
        }
        return (ServerOperationResult)wrapper.getObject();
    }

    public void setPersonalAccessToken(String token) {
        this.wsHttpClient.addRequestInterceptor((request, context) -> request.addHeader((Header)new BasicHeader("Authorization", "Bearer " + token)));
    }
}

