/*
 * Decompiled with CFR 0.152.
 */
package com.stonikbyte.projectdocs.bulkupload.common.ws;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.stonikbyte.projectdocs.bulkupload.common.ws.ApplicationSettings;
import com.stonikbyte.projectdocs.bulkupload.common.ws.JiraAuthenticationError;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.teodorbaciu.commons.client.ws.BaseWsMethods;
import ro.teodorbaciu.commons.client.ws.exceptions.InvalidLoginCredentialsException;
import ro.teodorbaciu.commons.client.ws.exceptions.MaxFailedLoginsExceededException;
import ro.teodorbaciu.commons.ws.transfer.beans.ObjectWrapper;

public class ProjectDocsBaseWsMethods
extends BaseWsMethods {
    private final ApplicationSettings jiraProperties;
    private static final Logger log = LoggerFactory.getLogger(ProjectDocsBaseWsMethods.class);

    public ProjectDocsBaseWsMethods(ApplicationSettings properties) {
        this.jiraProperties = properties;
        this.webserviceHost = this.jiraProperties.getJiraBaseUrl();
        this.authenticatedWebserviceUri = "/plugins/servlet/StonikByte/ws";
        this.setAllowUntruestedHttpsServer(properties.isIgnoreSSLCertficateErrors());
    }

    protected List<NameValuePair> getAuthenticationParams() {
        return new ArrayList<NameValuePair>();
    }

    public boolean authenticate(List<NameValuePair> authenticationParams) throws InvalidLoginCredentialsException, MaxFailedLoginsExceededException, UnsupportedEncodingException, ClientProtocolException, IOException {
        this.httpContext = new BasicHttpContext();
        String targetUrl = this.webserviceHost + "/rest/auth/latest/session";
        HttpGet request = new HttpGet(targetUrl);
        HttpResponse response = this.wsHttpClient.execute((HttpUriRequest)request, this.httpContext);
        int statusCode = response.getStatusLine().getStatusCode();
        String reasonPhrase = response.getStatusLine().getReasonPhrase();
        HttpEntity entity = response.getEntity();
        String jiraServerResponse = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
        if (statusCode != 200) {
            JiraAuthenticationError authError;
            String jiraAuthErrorMessages;
            log.debug("Received status code: " + statusCode + " reason phrase: " + reasonPhrase + " and the response body: " + jiraServerResponse);
            request.abort();
            if (statusCode == 401) {
                throw new InvalidLoginCredentialsException("The specified personal access token is not valid ");
            }
            if (statusCode == 403 && !StringUtils.isEmpty((String)(jiraAuthErrorMessages = (authError = (JiraAuthenticationError)new Gson().fromJson(jiraServerResponse, JiraAuthenticationError.class)).getErrorMessages())) && jiraAuthErrorMessages.contains("Login denied")) {
                throw new MaxFailedLoginsExceededException("Authentication error with response: " + jiraServerResponse);
            }
            return false;
        }
        request.abort();
        return true;
    }

    public boolean checkValidDocumentsAddonLicense() throws Exception {
        ArrayList listParams = new ArrayList();
        String response = this.callWsOperation("ws-module-upload-services", "ws-op-check-documents-addon-license", listParams);
        Type wrapperType = new TypeToken<ObjectWrapper<Boolean>>(){}.getType();
        ObjectWrapper wrapper = (ObjectWrapper)this.getGson().fromJson(response, wrapperType);
        if (!wrapper.isSuccess()) {
            throw new RuntimeException("Could not check the Documents add-on license: " + wrapper.getErrorMessage());
        }
        return (Boolean)wrapper.getObject();
    }

    public void updateHostFromJiraProperties() {
        this.webserviceHost = this.jiraProperties.getJiraBaseUrl();
    }

    public boolean authenticate() throws Exception {
        return this.authenticate(null);
    }

    public Gson getGson() {
        return new Gson();
    }

    public ApplicationSettings getJiraProperties() {
        return this.jiraProperties;
    }
}

