/*
 * Decompiled with CFR 0.152.
 */
package com.stonikbyte.projectdocs.bulkupload.swing.gui;

import com.stonikbyte.jira.plugins.projectdocs.beans.DocumentInfoBean;
import com.stonikbyte.jira.plugins.projectdocs.beans.FolderItem;
import com.stonikbyte.jira.plugins.projectdocs.beans.ServerOperationResult;
import com.stonikbyte.projectdocs.bulkupload.common.util.UploadResultsLogger;
import com.stonikbyte.projectdocs.bulkupload.common.util.Util;
import com.stonikbyte.projectdocs.bulkupload.common.ws.ApplicationSettings;
import com.stonikbyte.projectdocs.bulkupload.common.ws.BasicUploadParams;
import com.stonikbyte.projectdocs.bulkupload.common.ws.FileUploadWsMethods;
import com.stonikbyte.projectdocs.bulkupload.common.ws.ProjectDocsBaseWsMethods;
import com.stonikbyte.projectdocs.bulkupload.swing.gui.Document;
import com.stonikbyte.projectdocs.bulkupload.swing.gui.FolderMappingsManager;
import com.stonikbyte.projectdocs.bulkupload.swing.gui.MainWindow;
import java.io.File;
import java.net.UnknownHostException;
import javax.net.ssl.SSLException;
import javax.swing.UIManager;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.impl.client.DefaultHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.teodorbaciu.commons.client.ws.exceptions.InvalidLoginCredentialsException;
import ro.teodorbaciu.commons.client.ws.exceptions.MaxFailedLoginsExceededException;
import ro.teodorbaciu.commons.client.ws.progress.WriteListener;

public class Application {
    public static final String SSL_CERTIFICATE_ERROR_MESSAGE = "The JIRA server's security certificate is not trusted by the Java Runtime Enviroment. To ignore this error, please check the \n'Ignore SSL certificate errors' checkbox in the 'Edit authentication information' screen.\n However, before ignoring these type of errors, please consult with your network administrator";
    private static final Logger generalLogger = LoggerFactory.getLogger(Application.class);
    private static final UploadResultsLogger uploadResultsLogger = new UploadResultsLogger();
    private FileUploadWsMethods fileUploadMethodsWs;
    private ApplicationSettings jiraProperties;
    private FolderMappingsManager mappingsManager;
    private MainWindow mainWindow;
    private Document document;

    protected void initialize() throws Exception {
        this.jiraProperties = new ApplicationSettings("/app.properties");
        this.jiraProperties.readConfiguration();
        this.mappingsManager = new FolderMappingsManager("mappings.json");
        this.mappingsManager.readMappings();
        this.fileUploadMethodsWs = new FileUploadWsMethods(this.jiraProperties);
        DefaultHttpClient httpClient = new DefaultHttpClient();
        this.fileUploadMethodsWs.setWsHttpClient(httpClient);
        this.document = new Document(this);
        this.mainWindow = new MainWindow(this.document, this);
        this.document.setMainWindow(this.mainWindow);
    }

    public boolean isValidConfiguration() {
        return this.jiraProperties.isValidLoginInfo();
    }

    public FolderMappingsManager getMappingsManager() {
        return this.mappingsManager;
    }

    public static FileUploadWsMethods createWsMethods(String username, String password, String jiraServerUrl, boolean ignoreSSLCertificateErrors) {
        ApplicationSettings props = new ApplicationSettings(null);
        props.setUsername(username);
        props.setPassword(password);
        props.setJiraBaseUrl(jiraServerUrl);
        FileUploadWsMethods wsMethods = new FileUploadWsMethods(props);
        wsMethods.setAllowUntruestedHttpsServer(ignoreSSLCertificateErrors);
        DefaultHttpClient httpClient = new DefaultHttpClient();
        wsMethods.setWsHttpClient(httpClient);
        return wsMethods;
    }

    public static String checkAuthenticationInfo(ProjectDocsBaseWsMethods wsMethods) {
        try {
            boolean authenticated = wsMethods.authenticate();
            if (!authenticated) {
                return "Could not authenticate with the server. Please check the application logs for more information.";
            }
        }
        catch (InvalidLoginCredentialsException ile) {
            generalLogger.error("Invalid login credentials", (Throwable)ile);
            return "The specified credentials are not valid.";
        }
        catch (MaxFailedLoginsExceededException mfe) {
            generalLogger.error("max failed logins exceeded", (Throwable)mfe);
            return "You have exceeded the maximum number of failed logins that are allowed by the JIRA server.\nTo solve this error, please log in to your JIRA account using your browser.";
        }
        catch (UnknownHostException uhe) {
            generalLogger.error("Could not find host", (Throwable)uhe);
            return "Could not connect to host '" + wsMethods.getJiraProperties().getJiraBaseUrl() + "'. Please check the URL of the server.";
        }
        catch (SSLException spue) {
            generalLogger.error("SSL certificate error", (Throwable)spue);
            return SSL_CERTIFICATE_ERROR_MESSAGE;
        }
        catch (Exception e) {
            generalLogger.error("Generic error checking authentication parameters", (Throwable)e);
            return e.getMessage();
        }
        return null;
    }

    public Long getMaximumUploadSize() throws Exception {
        return this.fileUploadMethodsWs.getMaximumUploadSize();
    }

    public String getUploadApiVersion() throws Exception {
        return this.fileUploadMethodsWs.getUploadModuleVersion();
    }

    public static String checkValidDocumentsAddonLicense(ProjectDocsBaseWsMethods wsMethods) {
        String result = null;
        try {
            boolean licenseValid = wsMethods.checkValidDocumentsAddonLicense();
            if (!licenseValid) {
                result = "The license of your Documents add-on is not valid. To correct this problem, please contact your JIRA administrator.";
            }
        }
        catch (SSLException se) {
            generalLogger.error("SSL certificate error", (Throwable)se);
            result = SSL_CERTIFICATE_ERROR_MESSAGE;
        }
        catch (Exception e) {
            String msg = "Error checking validity of Documents add-on license.\nPlease contact your JIRA administrator. The error message is:\n" + e.getMessage();
            generalLogger.error(msg, (Throwable)e);
            result = msg;
        }
        return result;
    }

    public String checkValidDocumentsAddonLicense() {
        return Application.checkValidDocumentsAddonLicense((ProjectDocsBaseWsMethods)this.fileUploadMethodsWs);
    }

    public void setAuthenticationInfo(String username, String password, String jiraServerUrl, boolean saveToConfigFile, boolean ignoreSSLCertificateErrors) throws Exception {
        this.jiraProperties.setUsername(username);
        this.jiraProperties.setPassword(password);
        this.jiraProperties.setJiraBaseUrl(jiraServerUrl);
        this.jiraProperties.setEncoded(true);
        this.jiraProperties.setIgnoreSSLCertficateErrors(ignoreSSLCertificateErrors);
        this.fileUploadMethodsWs = Application.createWsMethods(username, password, jiraServerUrl, ignoreSSLCertificateErrors);
        this.fileUploadMethodsWs.authenticate();
        if (saveToConfigFile) {
            this.jiraProperties.saveConfiguration();
        }
    }

    public String getUsername() {
        return this.jiraProperties.getUsername();
    }

    public String getPassword() {
        return this.jiraProperties.getPassword();
    }

    public String getJiraBaseUrl() {
        return this.jiraProperties.getJiraBaseUrl();
    }

    public boolean isEncoded() {
        return this.jiraProperties.isEncoded();
    }

    public boolean ignoreSSLCertificateErrors() {
        return this.jiraProperties.isIgnoreSSLCertficateErrors();
    }

    public void exit() {
        try {
            this.mappingsManager.saveMappings();
        }
        catch (Exception e) {
            generalLogger.error("Error writing folder mappings to configuration file");
        }
        System.exit(0);
    }

    public boolean checkUploadRights(String idDestinationFolder) throws Exception {
        return this.fileUploadMethodsWs.checkUploadRights(idDestinationFolder);
    }

    public DocumentInfoBean getDocumentInfo(String idDocument) throws Exception {
        return this.fileUploadMethodsWs.getDocumentInfo(idDocument);
    }

    public MainWindow getMainWindow() {
        return this.mainWindow;
    }

    protected void setLookAndFeel() {
        try {
            String systemLaFName = UIManager.getSystemLookAndFeelClassName();
            UIManager.setLookAndFeel(systemLaFName);
        }
        catch (Exception e) {
            generalLogger.debug("Error setting LaF", (Throwable)e);
        }
    }

    protected void displayMainWindow() throws Exception {
        this.mainWindow.display();
        if (!this.jiraProperties.isValidLoginInfo()) {
            this.mainWindow.displayAuthInfoDialog(false);
        } else {
            boolean authenticated = false;
            try {
                authenticated = this.fileUploadMethodsWs.authenticate();
            }
            catch (InvalidLoginCredentialsException | MaxFailedLoginsExceededException e) {
                generalLogger.error("Call to authenticate() failed", e);
            }
            if (!authenticated) {
                this.mainWindow.displayAuthInfoDialog(true);
            }
        }
    }

    protected ServerOperationResult sendFile(String idDestinationFolder, FolderItem item, int rowIndex, boolean isUpload) throws Exception {
        String originalCRC = "" + FileUtils.checksumCRC32((File)item.getFileToUpload());
        UploadWriteListener listener = new UploadWriteListener(item, rowIndex);
        BasicUploadParams params = new BasicUploadParams();
        params.destFolderKey = idDestinationFolder;
        params.documentTitle = item.getDocumentTitle();
        params.filePath = item.getFileToUpload().getAbsolutePath();
        params.isUpload = isUpload;
        if (!isUpload) {
            params.lastModified = item.getFileToUpload().lastModified();
        }
        if (!StringUtils.isEmpty((String)item.getRelativePath())) {
            String destRelativePath;
            params.destRelativePath = destRelativePath = item.getRelativePath().replace(File.separator, "-->");
        }
        ServerOperationResult operationResult = this.fileUploadMethodsWs.sendFile(originalCRC, params, (WriteListener)listener);
        String message = Util.getOperationResultMessage((ServerOperationResult)operationResult, (String)params.filePath);
        generalLogger.info(message);
        uploadResultsLogger.log(message);
        return operationResult;
    }

    public static void main(String[] args) {
        try {
            Application app = new Application();
            app.setLookAndFeel();
            app.initialize();
            app.displayMainWindow();
        }
        catch (Exception e) {
            generalLogger.error("Error initializing application", (Throwable)e);
        }
    }

    class UploadWriteListener
    implements WriteListener {
        private double fileSize;
        private FolderItem item;
        private int rowIndex;

        public UploadWriteListener(FolderItem item, int rowIndex) {
            this.fileSize = item.getFileToUpload().length();
            this.item = item;
            this.rowIndex = rowIndex;
        }

        public void registerWrite(long numBytes) {
            double dPercentage = (double)numBytes / this.fileSize * 100.0;
            int percentage = (int)Math.floor(dPercentage);
            this.item.setUploadPercentage(percentage);
            Application.this.mainWindow.displayUploadPercentage(this.rowIndex, percentage);
        }
    }
}

