/*
 * Decompiled with CFR 0.152.
 */
package com.stonikbyte.projectdocs.bulkupload.swing.gui;

import com.stonikbyte.jira.plugins.projectdocs.beans.FolderItem;
import com.stonikbyte.jira.plugins.projectdocs.beans.FolderReadingResult;
import com.stonikbyte.jira.plugins.projectdocs.beans.ServerOperationResult;
import com.stonikbyte.projectdocs.bulkupload.common.util.UploadResultsLogger;
import com.stonikbyte.projectdocs.bulkupload.common.util.Util;
import com.stonikbyte.projectdocs.bulkupload.swing.gui.Application;
import com.stonikbyte.projectdocs.bulkupload.swing.gui.MainWindow;
import java.io.File;
import java.util.ArrayList;
import java.util.stream.Collectors;
import javax.swing.SwingUtilities;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Document {
    private static final Logger log = LoggerFactory.getLogger(Document.class);
    private static final UploadResultsLogger uploadResultsLogger = new UploadResultsLogger();
    private Application application;
    private MainWindow mainWindow;
    private ServerOperationStatus uploaderStatus;
    private Thread currentThread;
    private FolderReadingResult folderReadingResult;

    public Document(Application app) {
        this.application = app;
    }

    public void openFolder(File folder) {
        if (!folder.isDirectory()) {
            throw new IllegalArgumentException("The specified file must be a folder.");
        }
        this.folderReadingResult = new FolderReadingResult(folder);
        ReadFolderContentsTask task = new ReadFolderContentsTask(folder);
        Thread thread = new Thread(task);
        thread.start();
    }

    private void handleFolderReadingFinished() {
        String message;
        this.mainWindow.displayDocumentItems(this.folderReadingResult.getListItems());
        this.setServerOperationStatus(ServerOperationStatus.IDLE);
        if (this.folderReadingResult.isDocumentTitlesCleaned()) {
            message = "The title of one or more files was cleaned from invalid characters (quotation marks).\nThe name of the original files on your hard drive was *NOT* affected by this change.\nYou may now begin uploading the files.";
            this.mainWindow.displayInfoMessage(message);
        }
        if (this.folderReadingResult.isDocumentTitlesShortened()) {
            message = "The title of one or more files was shortened to a maximum of 255 characters.\nThe name of the original files on your hard drive was *NOT* affected by this change.\nYou may now begin uploading the files.";
            this.mainWindow.displayInfoMessage(message);
        }
    }

    public int verifyMaximumUploadSize(Long maximumUploadSize) {
        int result = 0;
        for (int i = 0; i < this.folderReadingResult.getListItems().size(); ++i) {
            FolderItem item = (FolderItem)this.folderReadingResult.getListItems().get(i);
            if (item.getFileToUpload().length() <= maximumUploadSize) continue;
            ++result;
            item.setServerOperationStatus(FolderItem.DocumentItemServerOperationStatus.IGNORE);
            this.mainWindow.updateRow(i);
        }
        return result;
    }

    public void addAdditionalFiles(File[] files) {
        ArrayList<FolderItem> listAdditionalFiles = new ArrayList<FolderItem>();
        for (File file : files) {
            if (file.isDirectory()) continue;
            FolderItem docItem = new FolderItem(file);
            docItem.computeDisplayRelativePath(this.folderReadingResult.getSelectedFolder());
            listAdditionalFiles.add(docItem);
        }
        this.folderReadingResult.addAll(listAdditionalFiles);
        this.mainWindow.displayAdditionalFiles(listAdditionalFiles);
    }

    public synchronized void startUpload(Integer idDestinationFolder, boolean isUpload) {
        if (this.uploaderStatus == ServerOperationStatus.IDLE) {
            this.currentThread = new Thread(new ServerOperationTask(idDestinationFolder, isUpload));
            this.currentThread.start();
        } else if (this.uploaderStatus == ServerOperationStatus.PAUSED) {
            this.uploaderStatus = isUpload ? ServerOperationStatus.RUNNING_UPLOAD : ServerOperationStatus.RUNNING_FILESYNC;
            this.notify();
            this.mainWindow.enablePauseUpload(true);
            this.mainWindow.displayUploadProgressBar(true);
        }
        this.mainWindow.enableStartServerOperation(false);
    }

    public synchronized void pauseUpload() {
        this.mainWindow.setStatusMessage("Pausing the upload process...");
        this.uploaderStatus = ServerOperationStatus.PAUSED;
        this.mainWindow.enablePauseUpload(false);
    }

    public synchronized void stopUpload() {
        this.mainWindow.setStatusMessage("Stopping the upload process...");
        if (this.uploaderStatus == ServerOperationStatus.PAUSED) {
            this.uploaderStatus = ServerOperationStatus.STOPPED;
            this.notify();
        } else {
            this.uploaderStatus = ServerOperationStatus.STOPPED;
        }
        this.mainWindow.enableStopUpload(false);
    }

    public FolderItem getDocumentItemAt(int rowIndex) {
        return (FolderItem)this.folderReadingResult.getListItems().get(rowIndex);
    }

    public synchronized boolean isUploadRunning() {
        return this.uploaderStatus == ServerOperationStatus.RUNNING_UPLOAD || this.uploaderStatus == ServerOperationStatus.PAUSED;
    }

    public synchronized ServerOperationStatus getServerOperationStatus() {
        return this.uploaderStatus;
    }

    private synchronized void setServerOperationStatus(ServerOperationStatus uploaderStatus) {
        this.uploaderStatus = uploaderStatus;
    }

    void setMainWindow(MainWindow mainWindow) {
        this.mainWindow = mainWindow;
    }

    public void removeItemsForIndices(int[] indices) {
        for (int i = 0; i < indices.length; ++i) {
            int index = indices[i] - i;
            this.folderReadingResult.remove(index);
        }
    }

    public File getSelectedFolder() {
        return this.folderReadingResult != null ? this.folderReadingResult.getSelectedFolder() : null;
    }

    protected boolean sendFileToServer(int index, FolderItem item, Integer idDestinationFolder, boolean isUpload) {
        String filePath = item.getFileToUpload().getAbsolutePath();
        boolean result = true;
        try {
            String documentKey;
            item.setServerOperationStatus(isUpload ? FolderItem.DocumentItemServerOperationStatus.UPLOADING : FolderItem.DocumentItemServerOperationStatus.SYNCING);
            this.mainWindow.updateRow(index);
            ServerOperationResult operationResult = this.application.sendFile(idDestinationFolder.toString(), item, index, isUpload);
            switch (operationResult.getType()) {
                case "sync-created-new-file": {
                    documentKey = operationResult.getResult().toString();
                    item.setServerOperationStatus(FolderItem.DocumentItemServerOperationStatus.SUCCESS_SYNC_NEW_DOC_CREATED);
                    break;
                }
                case "sync-created-new-version": {
                    documentKey = "";
                    item.setServerOperationStatus(FolderItem.DocumentItemServerOperationStatus.SUCCESS_SYNC_NEW_VERSION_CREATED);
                    break;
                }
                case "sync-skipped-more-than-one-document": {
                    documentKey = "";
                    item.setServerOperationStatus(FolderItem.DocumentItemServerOperationStatus.SYNC_SKIPPED_MORE_THAN_ONE_DOCUMENT);
                    break;
                }
                case "sync-skipped-same-contents": {
                    documentKey = "";
                    item.setServerOperationStatus(FolderItem.DocumentItemServerOperationStatus.SYNC_SKIPPED_SAME_CONTENTS);
                    break;
                }
                case "sync-skipped-server-newer": {
                    documentKey = operationResult.getResult().toString();
                    item.setServerOperationStatus(FolderItem.DocumentItemServerOperationStatus.SYNC_SKIPPED_SERVER_NEVER);
                    break;
                }
                case "upload-created-new-file": {
                    documentKey = operationResult.getResult().toString();
                    item.setServerOperationStatus(FolderItem.DocumentItemServerOperationStatus.SUCCESS_FILE_UPLOADED);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown server operation result type " + operationResult.getType());
                }
            }
            item.setUploadedDocumentKey(documentKey);
        }
        catch (Exception e) {
            log.error("Error uploading file.", (Throwable)e);
            String errorMessage = "Error: could not process file [" + filePath + "]. " + e.getMessage();
            log.error(errorMessage);
            uploadResultsLogger.log(errorMessage);
            item.setServerOperationStatus(FolderItem.DocumentItemServerOperationStatus.ERROR);
            result = false;
        }
        this.mainWindow.updateRow(index);
        return result;
    }

    private void displaySyncReport() {
        this.mainWindow.displaySyncReport(this.folderReadingResult.getListItems().stream().filter(documentItem -> documentItem.getServerOperationStatus() != FolderItem.DocumentItemServerOperationStatus.SUCCESS_SYNC_NEW_DOC_CREATED || documentItem.getServerOperationStatus() != FolderItem.DocumentItemServerOperationStatus.SUCCESS_SYNC_NEW_VERSION_CREATED).collect(Collectors.toList()));
    }

    public static enum ServerOperationStatus {
        IDLE("idle"),
        RUNNING_UPLOAD("running-upload"),
        RUNNING_FILESYNC("running-filesync"),
        PAUSED("paused"),
        STOPPED("stopped");

        String status;

        private ServerOperationStatus(String status) {
            this.status = status;
        }

        public String toString() {
            return this.status;
        }
    }

    private class ReadFolderContentsTask
    implements Runnable {
        private File folder;

        public ReadFolderContentsTask(File folder) {
            this.folder = folder;
        }

        @Override
        public void run() {
            try {
                Document.this.mainWindow.displayFolderReadingDialog();
                Document.this.folderReadingResult = Util.readFolderItems((File)this.folder);
                Thread.sleep(1000L);
                SwingUtilities.invokeLater(() -> Document.this.handleFolderReadingFinished());
            }
            catch (Exception e) {
                log.error("Error reading folder items", (Throwable)e);
                Document.this.mainWindow.displayErrorMessage("Error reading folder " + this.folder.getAbsolutePath(), "Error");
            }
            finally {
                Document.this.mainWindow.hideFolderReadingDialog();
            }
        }
    }

    private class ServerOperationTask
    implements Runnable {
        private final Integer idDestinationFolder;
        private final boolean isUpload;

        public ServerOperationTask(Integer idDestinationFolder, boolean isUpload) {
            this.idDestinationFolder = idDestinationFolder;
            this.isUpload = isUpload;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String operationNamePresentContinuos;
            int successCount = 0;
            int errorCount = 0;
            int skippedCount = 0;
            boolean serverOperationStoppedByUser = false;
            String operationName = this.isUpload ? "upload" : "sync";
            String operationNamePastTense = this.isUpload ? "uploaded" : "synced";
            String string = operationNamePresentContinuos = this.isUpload ? "uploading" : "syncing";
            if (this.isUpload) {
                Document.this.mainWindow.setGUIStateForUploading();
            } else {
                Document.this.mainWindow.setGUIStateForFilesync();
            }
            Document.this.mainWindow.enableTextInProgressbar(true);
            if (this.isUpload) {
                Document.this.setServerOperationStatus(ServerOperationStatus.RUNNING_UPLOAD);
            } else {
                Document.this.setServerOperationStatus(ServerOperationStatus.RUNNING_FILESYNC);
            }
            try {
                for (int i = 0; i < Document.this.folderReadingResult.getListItems().size(); ++i) {
                    FolderItem item = (FolderItem)Document.this.folderReadingResult.getListItems().get(i);
                    ServerOperationStatus serverOperationStatus = Document.this.getServerOperationStatus();
                    if (serverOperationStatus == ServerOperationStatus.PAUSED) {
                        Document.this.mainWindow.setGUIStateForPaused();
                        Document document = Document.this;
                        synchronized (document) {
                            Document.this.wait();
                        }
                    }
                    if (serverOperationStatus == ServerOperationStatus.STOPPED) {
                        Document.this.mainWindow.setGUIStateForStopped();
                        Document.this.mainWindow.setStatusMessage(String.format("<html><body><strong>%s stopped by the user. %d file(s) were %s</strong></body></html>", StringUtils.capitalize((String)operationName), successCount, operationNamePastTense));
                        serverOperationStoppedByUser = true;
                        break;
                    }
                    if (item.getServerOperationStatus() == FolderItem.DocumentItemServerOperationStatus.IGNORE) {
                        item.setServerOperationStatus(FolderItem.DocumentItemServerOperationStatus.IGNORED);
                        Document.this.mainWindow.updateRow(i);
                        ++skippedCount;
                        continue;
                    }
                    String statusMessage = String.format("%s file %d of %d...", StringUtils.capitalize((String)operationNamePastTense), i + 1, Document.this.folderReadingResult.getListItems().size());
                    Document.this.mainWindow.setStatusMessage(statusMessage);
                    String currentFilename = item.getDocumentTitle();
                    Document.this.mainWindow.setCurrentFilename(StringUtils.abbreviate((String)currentFilename, (int)100));
                    boolean uploadSucessful = Document.this.sendFileToServer(i, item, this.idDestinationFolder, this.isUpload);
                    if (uploadSucessful) {
                        switch (item.getServerOperationStatus()) {
                            case SUCCESS_FILE_UPLOADED: 
                            case SUCCESS_SYNC_NEW_DOC_CREATED: 
                            case SUCCESS_SYNC_NEW_VERSION_CREATED: {
                                ++successCount;
                                break;
                            }
                            case IGNORED: 
                            case SYNC_SKIPPED_MORE_THAN_ONE_DOCUMENT: 
                            case SYNC_SKIPPED_SAME_CONTENTS: 
                            case SYNC_SKIPPED_SERVER_NEVER: {
                                ++skippedCount;
                            }
                        }
                        continue;
                    }
                    ++errorCount;
                }
                Document.this.mainWindow.enableTextInProgressbar(false);
                Document.this.mainWindow.setCurrentFilename("");
                Document.this.mainWindow.displayUploadPercentage(0, 0);
            }
            catch (Exception e) {
                log.debug(String.format("Error %s files", operationNamePresentContinuos), (Throwable)e);
            }
            Document.this.mainWindow.setGUIStateForStopped();
            Document.this.setServerOperationStatus(ServerOperationStatus.STOPPED);
            if (!serverOperationStoppedByUser) {
                if (successCount == Document.this.folderReadingResult.getListItems().size()) {
                    Document.this.mainWindow.setStatusMessage(String.format("<html><body><strong>All files have been successfully %s</strong></body></html>", operationNamePastTense));
                } else if (errorCount == Document.this.folderReadingResult.getListItems().size()) {
                    Document.this.mainWindow.setStatusMessage(String.format("<html><body><strong>Error: None of the files could be %s.</strong></body></html>", operationNamePastTense));
                } else if (errorCount > 0) {
                    String statusMessage = String.format("<html><body><strong>%d file(s) successfully %s, %d file(s) could not be %s and %d skipped</strong></body></html>", successCount, operationNamePastTense, errorCount, operationNamePastTense, skippedCount);
                    Document.this.mainWindow.setStatusMessage(statusMessage);
                    if (!this.isUpload) {
                        Document.this.displaySyncReport();
                    }
                }
                if (errorCount == 0 && skippedCount > 0) {
                    String message = String.format("<html><body><strong> %d file(s) were not %s. For more information hover the mouse over the file(s)</strong></body></html>", skippedCount, operationNamePastTense);
                    Document.this.mainWindow.setStatusMessage(message);
                    if (!this.isUpload) {
                        Document.this.displaySyncReport();
                    }
                }
            }
        }
    }
}

