/*
 * Decompiled with CFR 0.152.
 */
package com.stonikbyte.projectdocs.bulkupload.swing.gui;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.stonikbyte.projectdocs.bulkupload.swing.gui.FolderMapping;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FolderMappingsManager {
    private static final Logger log = LoggerFactory.getLogger(FolderMappingsManager.class);
    private String nameConfigFile;
    private ArrayList<FolderMapping> listFolderMappings;

    public FolderMappingsManager(String pathConfigFile) {
        this.nameConfigFile = pathConfigFile;
        this.listFolderMappings = new ArrayList();
    }

    public boolean saveMapping(FolderMapping mapping) {
        int elementIndex = this.listFolderMappings.indexOf(mapping);
        if (elementIndex != -1) {
            this.listFolderMappings.set(elementIndex, mapping);
        } else {
            this.listFolderMappings.add(mapping);
        }
        try {
            this.saveMappings();
        }
        catch (IOException e) {
            log.error("Error saving mapping", (Throwable)e);
            return false;
        }
        return true;
    }

    Optional<FolderMapping> getFolderMapping(String localPath) {
        return this.listFolderMappings.stream().filter(mapping -> mapping.getPathLocalFolder().equalsIgnoreCase(localPath)).findFirst();
    }

    public List<FolderMapping> getListMappings() {
        return Collections.unmodifiableList(this.listFolderMappings);
    }

    public void readMappings() throws IOException {
        try (FileInputStream isConfigFile = new FileInputStream(this.getConfigFile());){
            String configuration = IOUtils.toString((InputStream)isConfigFile);
            if (StringUtils.isBlank((String)configuration)) {
                this.listFolderMappings = new ArrayList();
                return;
            }
            Gson gson = new Gson();
            Type typeMappingsList = new TypeToken<List<FolderMapping>>(){}.getType();
            this.listFolderMappings = new ArrayList((Collection)gson.fromJson(configuration, typeMappingsList));
        }
    }

    public void saveMappings() throws IOException {
        Gson gson = new Gson();
        Type typeMappingsList = new TypeToken<List<FolderMapping>>(){}.getType();
        String configuration = gson.toJson(this.listFolderMappings, typeMappingsList);
        try (FileOutputStream outConfigFile = new FileOutputStream(this.getConfigFile());
             PrintWriter pw = new PrintWriter(outConfigFile);){
            pw.write(configuration);
            pw.flush();
        }
    }

    protected File getConfigFile() throws IOException {
        File result = new File(this.nameConfigFile);
        if (!result.exists()) {
            result.createNewFile();
        }
        return result;
    }
}

