/*
 * Decompiled with CFR 0.152.
 */
package com.stonikbyte.projectdocs.bulkupload.swing.gui;

import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.stonikbyte.projectdocs.bulkupload.common.ws.FileUploadWsMethods;
import com.stonikbyte.projectdocs.bulkupload.common.ws.ProjectDocsBaseWsMethods;
import com.stonikbyte.projectdocs.bulkupload.swing.gui.Application;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraAuthInfoDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(JiraAuthInfoDialog.class);
    private final JPanel contentPanel = new JPanel();
    private String result = null;
    public static String OK_RESULT = "result-ok";
    public static String CANCEL_RESULT = "result-cancel";
    private JTextField tfUsername;
    private JPasswordField tfPassword;
    private JTextField tfJiraServerUrl;
    private JCheckBox cbRememberCredentials;
    private Application application;
    private JButton okButton;
    private JButton cancelButton;
    private JPanel panelCurrentOperation;
    private JButton btnValidate;
    private boolean validationRunning;
    private JCheckBox cbIgnoreSSLCertificateErrors;
    private boolean invalidCredentials = false;

    public JiraAuthInfoDialog(Frame parent, Application application) {
        super(parent);
        this.application = application;
        this.initGUI();
    }

    private void initGUI() {
        this.getContentPane().setLayout(new BorderLayout());
        JiraAuthInfoDialog.addEscapeListener(this);
        this.contentPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"min(120dlu;pref)")}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.BUTTON_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.BUTTON_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC}));
        JLabel lbDescription = new JLabel("<html>\r\n<body>\r\n<p>\r\nThis screen allows you to specify the authentication information required to upload files to your Documents add-on installation. <br/>\r\n</p>\r\n</body>\r\n</html>");
        this.contentPanel.add((Component)lbDescription, "2, 2, left, bottom");
        JLabel lblUsername = new JLabel("Username");
        this.contentPanel.add((Component)lblUsername, "2, 4");
        this.tfUsername = new JTextField();
        this.contentPanel.add((Component)this.tfUsername, "2, 6, fill, default");
        this.tfUsername.setColumns(10);
        JLabel lblPassword = new JLabel("Password");
        this.contentPanel.add((Component)lblPassword, "2, 8");
        this.tfPassword = new JPasswordField();
        this.contentPanel.add((Component)this.tfPassword, "2, 10, fill, default");
        JLabel lblJiraServerUrl = new JLabel("JIRA Base URL");
        this.contentPanel.add((Component)lblJiraServerUrl, "2, 12");
        this.tfJiraServerUrl = new JTextField();
        this.contentPanel.add((Component)this.tfJiraServerUrl, "2, 14, fill, default");
        this.tfJiraServerUrl.setColumns(10);
        this.cbIgnoreSSLCertificateErrors = new JCheckBox("Ignore SSL certificate errors");
        this.cbIgnoreSSLCertificateErrors.setToolTipText("<html><body>If this option is checked, all connection errors caused by SSL certificates<br/> that are being considered invalid will be ignored. Please consult with your <br/> network administrator before ignoring such errors.<body></html>");
        this.contentPanel.add((Component)this.cbIgnoreSSLCertificateErrors, "2, 16");
        this.cbRememberCredentials = new JCheckBox("<html><body><strong>Remember credentials</strong></body></html>");
        this.cbRememberCredentials.setSelected(true);
        this.contentPanel.add((Component)this.cbRememberCredentials, "2, 18");
        this.panelCurrentOperation = new JPanel();
        this.panelCurrentOperation.setVisible(false);
        this.contentPanel.add((Component)this.panelCurrentOperation, "2, 20");
        this.panelCurrentOperation.setLayout(new BorderLayout(10, 0));
        JLabel lbCurrentOperation = new JLabel("Checking credentials");
        this.panelCurrentOperation.add((Component)lbCurrentOperation, "West");
        JProgressBar progressBarCurrentOperation = new JProgressBar();
        progressBarCurrentOperation.setIndeterminate(true);
        this.panelCurrentOperation.add(progressBarCurrentOperation);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(1));
        this.getContentPane().add((Component)buttonPane, "South");
        int preferredHeight = 30;
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(e -> this.onOkPressed());
        Dimension preferredSize = this.okButton.getPreferredSize();
        if (preferredSize != null) {
            preferredHeight = preferredSize.height;
        }
        this.okButton.setPreferredSize(new Dimension(70, preferredHeight));
        this.okButton.setActionCommand("OK");
        buttonPane.add(this.okButton);
        this.getRootPane().setDefaultButton(this.okButton);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(e -> this.onCancelPressed());
        this.cancelButton.setPreferredSize(new Dimension(70, preferredHeight));
        this.cancelButton.setActionCommand("Cancel");
        buttonPane.add(this.cancelButton);
        this.btnValidate = new JButton("Validate");
        this.btnValidate.addActionListener(e -> this.onValidatePressed());
        this.btnValidate.setToolTipText("Checks if the specified information is valid");
        buttonPane.add(this.btnValidate);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (JiraAuthInfoDialog.this.isValidationRunning()) {
                    JOptionPane.showMessageDialog(JiraAuthInfoDialog.this, "Please wait until the validation operation finishes.", "Information", 1);
                    return;
                }
                JiraAuthInfoDialog.this.onCancelPressed();
            }

            @Override
            public void windowOpened(WindowEvent e) {
                super.windowOpened(e);
                if (JiraAuthInfoDialog.this.invalidCredentials) {
                    JiraAuthInfoDialog.this.invalidCredentials = false;
                    JOptionPane.showMessageDialog(JiraAuthInfoDialog.this, "Invalid credentials.", "Error", 0);
                }
            }
        });
        this.setDefaultCloseOperation(0);
        this.setTitle("Edit authentication information");
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.setModal(true);
        this.pack();
    }

    public static void addEscapeListener(final JDialog dialog) {
        ActionListener escListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.dispatchEvent(new WindowEvent(dialog, 201));
            }
        };
        dialog.getRootPane().registerKeyboardAction(escListener, KeyStroke.getKeyStroke(27, 0), 2);
    }

    public synchronized boolean isValidationRunning() {
        return this.validationRunning;
    }

    public synchronized void setValidationRunning(boolean validationRunning) {
        this.validationRunning = validationRunning;
    }

    public void setUsername(String username) {
        this.tfUsername.setText(username);
    }

    public void setPassword(String password) {
        this.tfPassword.setText(password);
    }

    public void setJiraBaseUrl(String url) {
        this.tfJiraServerUrl.setText(url);
    }

    public void setIgnoreSSLCertificateErrors(boolean ignore) {
        this.cbIgnoreSSLCertificateErrors.setSelected(ignore);
    }

    public void enableCBRemeberCredentials() {
        this.cbRememberCredentials.setSelected(true);
    }

    public String getUsername() {
        return this.tfUsername.getText();
    }

    public String getPassword() {
        return new String(this.tfPassword.getPassword());
    }

    public String getJiraServerUrl() {
        return this.tfJiraServerUrl.getText();
    }

    public boolean getRememberCredentials() {
        return this.cbRememberCredentials.isSelected();
    }

    protected boolean validateUserEnteredInformation() {
        if (StringUtils.isEmpty((String)this.tfUsername.getText())) {
            JOptionPane.showMessageDialog(this, "The Username field is empty");
            this.tfUsername.requestFocus();
            return false;
        }
        if (StringUtils.isEmpty((String)new String(this.tfPassword.getPassword()))) {
            JOptionPane.showMessageDialog(this, "The Password field is empty");
            this.tfPassword.requestFocus();
            return false;
        }
        if (StringUtils.isEmpty((String)this.tfJiraServerUrl.getText())) {
            JOptionPane.showMessageDialog(this, "The specified JIRA Base URL is empty.");
            this.tfJiraServerUrl.requestFocus();
            return false;
        }
        if (this.tfJiraServerUrl.getText().endsWith("/")) {
            JOptionPane.showMessageDialog(this, "Please make sure that the specified JIRA Base URL does not end with a trailing slash \"/\" character.");
            this.tfJiraServerUrl.requestFocus();
            return false;
        }
        try {
            new URL(this.tfJiraServerUrl.getText());
        }
        catch (MalformedURLException e) {
            JOptionPane.showMessageDialog(this, "The specified JIRA Base-URL is not a valid URL.");
            this.tfJiraServerUrl.requestFocus();
            return false;
        }
        return true;
    }

    protected void onValidatePressed() {
        this.validateCredentials(false);
    }

    protected void validateCredentials(boolean onOkPressed) {
        if (!this.validateUserEnteredInformation()) {
            return;
        }
        String username = this.tfUsername.getText();
        String password = new String(this.tfPassword.getPassword());
        String jiraServerUrl = this.tfJiraServerUrl.getText();
        boolean ignoreSSLCertificateErrors = this.cbIgnoreSSLCertificateErrors.isSelected();
        this.setStateForChecking(false);
        CheckAuthenticationTask task = new CheckAuthenticationTask(username, password, jiraServerUrl, ignoreSSLCertificateErrors, onOkPressed, this.cbRememberCredentials.isSelected());
        Thread validatorThread = new Thread(task);
        validatorThread.start();
    }

    protected void onOkPressed() {
        this.validateCredentials(true);
    }

    protected void setStateForChecking(boolean enabled) {
        SwingUtilities.invokeLater(() -> {
            this.tfUsername.setEnabled(enabled);
            this.tfPassword.setEnabled(enabled);
            this.tfJiraServerUrl.setEnabled(enabled);
            this.okButton.setEnabled(enabled);
            this.cancelButton.setEnabled(enabled);
            this.btnValidate.setEnabled(enabled);
            this.cbRememberCredentials.setEnabled(enabled);
            this.cbIgnoreSSLCertificateErrors.setEnabled(enabled);
            this.panelCurrentOperation.setVisible(!enabled);
            this.pack();
        });
    }

    protected void onCancelPressed() {
        this.result = CANCEL_RESULT;
        this.setVisible(false);
    }

    public String getResult() {
        return this.result;
    }

    public void setInvalidCredentials(boolean invalidCredentials) {
        this.invalidCredentials = invalidCredentials;
    }

    private class CheckAuthenticationTask
    implements Runnable {
        private final boolean onOkPressed;
        private String username;
        private String password;
        private String jiraServerUrl;
        private boolean ignoreSSLCertificateErrors;
        private final boolean rememberCredentials;

        public CheckAuthenticationTask(String username, String password, String jiraServerUrl, boolean ignoreSSLCertificateErrors, boolean onOkPressed, boolean rememberCredentials) {
            this.username = username;
            this.password = password;
            this.jiraServerUrl = jiraServerUrl;
            this.ignoreSSLCertificateErrors = ignoreSSLCertificateErrors;
            this.onOkPressed = onOkPressed;
            this.rememberCredentials = rememberCredentials;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block8: {
                try {
                    JiraAuthInfoDialog.this.setValidationRunning(true);
                    FileUploadWsMethods wsMethods = Application.createWsMethods(this.username, this.password, this.jiraServerUrl, this.ignoreSSLCertificateErrors);
                    JiraAuthInfoDialog.this.application;
                    String verifyMessage = Application.checkAuthenticationInfo((ProjectDocsBaseWsMethods)wsMethods);
                    if (verifyMessage == null) {
                        JiraAuthInfoDialog.this.application;
                        String validLicenseMessage = Application.checkValidDocumentsAddonLicense((ProjectDocsBaseWsMethods)wsMethods);
                        JiraAuthInfoDialog.this.setValidationRunning(false);
                        if (validLicenseMessage == null) {
                            if (this.onOkPressed) {
                                try {
                                    JiraAuthInfoDialog.this.application.setAuthenticationInfo(this.username, this.password, this.jiraServerUrl, this.rememberCredentials, this.ignoreSSLCertificateErrors);
                                }
                                catch (Exception e) {
                                    log.error("Error saving authentication information.", (Throwable)e);
                                    JOptionPane.showMessageDialog(JiraAuthInfoDialog.this, "Error saving authentication information. " + e.getMessage(), "Error", 0);
                                }
                                JiraAuthInfoDialog.this.setVisible(false);
                                break block8;
                            }
                            SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(JiraAuthInfoDialog.this, "The supplied credentials are valid and can be used to upload files.", "Success", 1));
                            break block8;
                        }
                        SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(JiraAuthInfoDialog.this, validLicenseMessage, "Invalid Documents add-on license", 0));
                        break block8;
                    }
                    JiraAuthInfoDialog.this.setStateForChecking(false);
                    SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(JiraAuthInfoDialog.this, verifyMessage, "Invalid credentials", 0));
                }
                finally {
                    JiraAuthInfoDialog.this.setStateForChecking(true);
                    JiraAuthInfoDialog.this.setValidationRunning(false);
                }
            }
        }
    }
}

