/*
 * Decompiled with CFR 0.152.
 */
package com.stonikbyte.projectdocs.bulkupload.swing.gui;

import com.stonikbyte.jira.plugins.projectdocs.beans.DocumentInfoBean;
import com.stonikbyte.jira.plugins.projectdocs.beans.FolderItem;
import com.stonikbyte.projectdocs.bulkupload.swing.gui.AboutDialog;
import com.stonikbyte.projectdocs.bulkupload.swing.gui.Application;
import com.stonikbyte.projectdocs.bulkupload.swing.gui.Document;
import com.stonikbyte.projectdocs.bulkupload.swing.gui.DocumentItemTable;
import com.stonikbyte.projectdocs.bulkupload.swing.gui.FolderMapping;
import com.stonikbyte.projectdocs.bulkupload.swing.gui.FolderMappingsManager;
import com.stonikbyte.projectdocs.bulkupload.swing.gui.FolderReadingProgressDialog;
import com.stonikbyte.projectdocs.bulkupload.swing.gui.JiraAuthInfoDialog;
import com.stonikbyte.projectdocs.bulkupload.swing.gui.OperationProgressDialog;
import com.stonikbyte.projectdocs.bulkupload.swing.gui.SyncReportDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import javax.net.ssl.SSLException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.teodorbaciu.commons.client.ws.exceptions.ReAuthenticationException;

public class MainWindow {
    private static final String MAIN_WINDOW_TITLE = "Documents Bulk Uploader";
    private static final Logger log = LoggerFactory.getLogger(MainWindow.class);
    public static final String ERROR_MESSAGE_API_VERSION_MISMATCH = "Cannot sync/import the files because the current installation of the Bulk Uploader is not compatible with your Documents Jira add-on.\nPlease use a Bulk Uploader version that is compatible with the upload API version %s\nFor more information, please check the online documentation for the StonikByte Documents add-on.";
    private JFrame frmDocumentsBulkUpload;
    private final Action actionOpenFolder = new ActionOpenFolder();
    private final Action actionAbout = new ActionAbout();
    private final Action actionExitApplication = new ActionExitApplication();
    private final ActionStartUpload actionStartUpload = new ActionStartUpload();
    private final ActionStartFilesync actionStartFilesync = new ActionStartFilesync();
    private final Action actionPauseUpload = new ActionPauseServerOperation();
    private final Action actionStopUpload = new ActionStopServerOperation();
    private final Action actionDisplayAuthInfo = new ActionDisplayAuthInfo();
    private final Action actionAddFiles = new ActionAddAdditionalFiles();
    private final Action actionRemoveFiles = new ActionRemoveFiles();
    private final Action actionEditDocumentName = new ActionEditDocumentName();
    private JTable table;
    private Document document;
    private Application application;
    private JLabel lbStatusBarMessage;
    private JProgressBar uploadProgressBar;
    private JLabel lbCurrentFilename;
    private JButton btnStartUpload;
    private OperationProgressDialog serverOpDialog;
    private FolderReadingProgressDialog folderReadingDialog;
    private File prevSelectedFolder;
    private JButton btnStartFilesync;

    public MainWindow(Document doc, Application application) {
        this.document = doc;
        this.application = application;
        this.initialize();
    }

    private void initialize() {
        this.frmDocumentsBulkUpload = new JFrame();
        this.frmDocumentsBulkUpload.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                MainWindow.this.onExitApplication();
            }
        });
        this.frmDocumentsBulkUpload.setTitle(MAIN_WINDOW_TITLE);
        this.frmDocumentsBulkUpload.setSize(1024, 700);
        this.frmDocumentsBulkUpload.setDefaultCloseOperation(0);
        JMenuBar menuBar = new JMenuBar();
        this.frmDocumentsBulkUpload.setJMenuBar(menuBar);
        JMenu mnFile = new JMenu("File");
        mnFile.setMnemonic(70);
        menuBar.add(mnFile);
        JMenuItem mntmOpenFolder = new JMenuItem("Open folder");
        mntmOpenFolder.setAction(this.actionOpenFolder);
        mntmOpenFolder.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        mntmOpenFolder.setMnemonic(79);
        mnFile.add(mntmOpenFolder);
        JMenuItem mntDisplayAuthInfo = new JMenuItem();
        mntDisplayAuthInfo.setAction(this.actionDisplayAuthInfo);
        mnFile.add(mntDisplayAuthInfo);
        JMenuItem mntmExit = mnFile.add(this.actionExitApplication);
        mntmExit.setAction(this.actionExitApplication);
        mntmExit.setMnemonic(88);
        JMenu mnNewMenu = new JMenu("Help");
        mnNewMenu.setMnemonic(72);
        menuBar.add(mnNewMenu);
        JMenuItem mntmAbout = mnNewMenu.add(this.actionAbout);
        mntmAbout.setAction(this.actionAbout);
        mntmAbout.setMnemonic(65);
        this.frmDocumentsBulkUpload.getContentPane().setLayout(new BorderLayout(0, 2));
        JPanel panelStatusBar = new JPanel();
        this.frmDocumentsBulkUpload.getContentPane().add((Component)panelStatusBar, "South");
        panelStatusBar.setLayout(new BorderLayout(3, 3));
        this.lbStatusBarMessage = new JLabel("<html><body>Click <strong>Select folder...</strong> to select the folder that will be synchronized or imported");
        this.lbStatusBarMessage.setHorizontalAlignment(2);
        this.lbStatusBarMessage.setPreferredSize(new Dimension(46, 28));
        panelStatusBar.add((Component)this.lbStatusBarMessage, "Center");
        JPanel panel = new JPanel();
        panelStatusBar.add((Component)panel, "East");
        panel.setLayout(new BorderLayout(5, 0));
        this.uploadProgressBar = new JProgressBar();
        this.uploadProgressBar.setVisible(false);
        panel.add((Component)this.uploadProgressBar, "East");
        this.lbCurrentFilename = new JLabel("");
        this.lbCurrentFilename.setHorizontalAlignment(4);
        this.lbCurrentFilename.setPreferredSize(new Dimension(150, 0));
        this.lbCurrentFilename.setMinimumSize(new Dimension(100, 0));
        panel.add(this.lbCurrentFilename);
        this.table = new DocumentItemTable();
        this.table.setEnabled(false);
        this.table.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "startEditing");
        JScrollPane scrollPane = new JScrollPane(this.table);
        this.frmDocumentsBulkUpload.getContentPane().add((Component)scrollPane, "Center");
        ImageIcon appIcon16x16 = new ImageIcon(MainWindow.class.getResource("/images/documents-logo-16x16.png"));
        ImageIcon appIcon32x32 = new ImageIcon(MainWindow.class.getResource("/images/documents-logo-32x32.png"));
        ImageIcon appIcon64x64 = new ImageIcon(MainWindow.class.getResource("/images/documents-logo-64x64.png"));
        List<Image> listIcons = Arrays.asList(appIcon16x16.getImage(), appIcon32x32.getImage(), appIcon64x64.getImage());
        this.frmDocumentsBulkUpload.setIconImages(listIcons);
        this.actionStartFilesync.setEnabled(false);
        this.actionStartUpload.setEnabled(false);
        this.actionStopUpload.setEnabled(false);
        this.actionPauseUpload.setEnabled(false);
        JPanel northPanel = new JPanel();
        FlowLayout flowLayout = (FlowLayout)northPanel.getLayout();
        flowLayout.setVgap(0);
        flowLayout.setHgap(0);
        flowLayout.setAlignment(0);
        this.frmDocumentsBulkUpload.getContentPane().add((Component)northPanel, "North");
        JToolBar toolbarFileOperations = new JToolBar();
        northPanel.add(toolbarFileOperations);
        JButton btnOpenFolder = toolbarFileOperations.add(this.actionOpenFolder);
        btnOpenFolder.setIcon(new ImageIcon(MainWindow.class.getResource("/images/icon-open-folder-32x32.png")));
        toolbarFileOperations.add(btnOpenFolder);
        JButton btnAddAditionalFiles = toolbarFileOperations.add(this.actionAddFiles);
        btnAddAditionalFiles.setIcon(new ImageIcon(MainWindow.class.getResource("/images/icon-add-32x32.png")));
        toolbarFileOperations.add(btnAddAditionalFiles);
        JButton btnEditDocumentName = toolbarFileOperations.add(this.actionEditDocumentName);
        btnEditDocumentName.setIcon(new ImageIcon(MainWindow.class.getResource("/images/icon-edit-32x32.png")));
        toolbarFileOperations.add(btnEditDocumentName);
        JButton btnRemoveFiles = toolbarFileOperations.add(this.actionRemoveFiles);
        btnRemoveFiles.setIcon(new ImageIcon(MainWindow.class.getResource("/images/icon-remove-32x32.png")));
        toolbarFileOperations.add(btnRemoveFiles);
        JToolBar toolbarUploadControls = new JToolBar();
        northPanel.add(toolbarUploadControls);
        this.btnStartFilesync = toolbarUploadControls.add(this.actionStartFilesync);
        this.btnStartFilesync.setIcon(new ImageIcon(MainWindow.class.getResource("/images/sync.png")));
        this.btnStartUpload = toolbarUploadControls.add(this.actionStartUpload);
        this.btnStartUpload.setIcon(new ImageIcon(MainWindow.class.getResource("/images/play.png")));
        JButton btnPauseUpload = toolbarUploadControls.add(this.actionPauseUpload);
        btnPauseUpload.setIcon(new ImageIcon(MainWindow.class.getResource("/images/pause.png")));
        JButton btnStopUpload = toolbarUploadControls.add(this.actionStopUpload);
        btnStopUpload.setIcon(new ImageIcon(MainWindow.class.getResource("/images/stop.png")));
        this.actionAddFiles.setEnabled(false);
        this.actionRemoveFiles.setEnabled(false);
        this.actionEditDocumentName.setEnabled(false);
        this.frmDocumentsBulkUpload.setLocationByPlatform(true);
        this.serverOpDialog = new OperationProgressDialog();
        this.folderReadingDialog = new FolderReadingProgressDialog();
    }

    protected void onAddAditionalFiles() {
        int returnVal;
        JFileChooser chooser = new JFileChooser();
        chooser.setMultiSelectionEnabled(true);
        chooser.setFileSelectionMode(0);
        if (this.prevSelectedFolder != null) {
            chooser.setCurrentDirectory(this.prevSelectedFolder);
        }
        if ((returnVal = chooser.showOpenDialog(this.frmDocumentsBulkUpload)) == 0) {
            File[] selectedFiles = chooser.getSelectedFiles();
            if (selectedFiles.length == 0) {
                JOptionPane.showMessageDialog(this.frmDocumentsBulkUpload, "Please select at least one file to add.");
                return;
            }
            this.prevSelectedFolder = selectedFiles[0].getParentFile();
            this.document.addAdditionalFiles(selectedFiles);
        }
    }

    protected void onRemoveFiles() {
        int[] selectRowsIndices = this.table.getSelectedRows();
        if (selectRowsIndices.length == 0) {
            JOptionPane.showMessageDialog(this.frmDocumentsBulkUpload, "Please select at least one row to remove.");
            return;
        }
        int res = JOptionPane.showConfirmDialog(this.frmDocumentsBulkUpload, "Are you sure you want to remove the selected file(s) from the upload list?", "Confirm remove", 0);
        if (res != 0) {
            return;
        }
        DocumentItemsTableModel tableModel = (DocumentItemsTableModel)this.table.getModel();
        int originalRowCount = tableModel.getRowCount();
        this.document.removeItemsForIndices(selectRowsIndices);
        tableModel.fireTableRowsDeleted(0, originalRowCount);
    }

    protected void onEditDocumentName() {
        int[] selectRowsIndices = this.table.getSelectedRows();
        if (selectRowsIndices.length == 0) {
            JOptionPane.showMessageDialog(this.frmDocumentsBulkUpload, "Please select one row to edit its title.");
            return;
        }
        if (selectRowsIndices.length > 1) {
            JOptionPane.showMessageDialog(this.frmDocumentsBulkUpload, "Please select only one row for editing its title.");
            return;
        }
        FolderItem selectedItem = this.document.getDocumentItemAt(selectRowsIndices[0]);
        if (selectedItem.getServerOperationStatus() == FolderItem.DocumentItemServerOperationStatus.SUCCESS_FILE_UPLOADED) {
            String message = "The document title cannot be changed because the file was already uploaded.";
            JOptionPane.showMessageDialog(this.frmDocumentsBulkUpload, message, "Info", 1);
            return;
        }
        if (selectedItem.getServerOperationStatus() != FolderItem.DocumentItemServerOperationStatus.PENDING) {
            String message = "The document title cannot be changed because the status of the file is: " + selectedItem.getServerOperationStatus();
            JOptionPane.showMessageDialog(this.frmDocumentsBulkUpload, message, "Info", 1);
            return;
        }
        String newDocumentTitle = selectedItem.getDocumentTitle();
        do {
            if ((newDocumentTitle = JOptionPane.showInputDialog(this.frmDocumentsBulkUpload, "Edit document title", newDocumentTitle)) != null) continue;
            return;
        } while (!this.isDocumentTitleValid(newDocumentTitle));
        selectedItem.setDocumentTitle(newDocumentTitle);
        DocumentItemsTableModel tableModel = (DocumentItemsTableModel)this.table.getModel();
        tableModel.fireTableRowsUpdated(selectRowsIndices[0], selectRowsIndices[0]);
    }

    boolean isDocumentTitleValid(String documentTitle) {
        if (StringUtils.isEmpty((String)documentTitle)) {
            JOptionPane.showMessageDialog(this.frmDocumentsBulkUpload, "The specified document title cannot be empty.", "Validation error", 0);
            return false;
        }
        if (documentTitle.length() > 255) {
            JOptionPane.showMessageDialog(this.frmDocumentsBulkUpload, "The length of the Document title must be less than 255 characters.", "Validation error", 0);
            return false;
        }
        if (documentTitle.contains("\"")) {
            JOptionPane.showMessageDialog(this.frmDocumentsBulkUpload, "The specified document title cannot contain double quotation marks.", "Validation error", 0);
            return false;
        }
        return true;
    }

    protected void onOpenFolder() {
        int returnVal;
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        File prevSelectedFolder = this.document.getSelectedFolder();
        if (prevSelectedFolder != null) {
            chooser.setCurrentDirectory(prevSelectedFolder);
        }
        if ((returnVal = chooser.showOpenDialog(this.frmDocumentsBulkUpload)) == 0) {
            File selectedFile = chooser.getSelectedFile();
            this.document.openFolder(selectedFile);
            String title = "Documents Bulk Uploader [" + selectedFile.getAbsolutePath() + "]";
            this.frmDocumentsBulkUpload.setTitle(title);
            this.actionStartFilesync.setEnabled(true);
            this.actionStartUpload.setEnabled(true);
            this.enableFileOperations(true);
            this.setStatusMessage("<html><body>Click <strong>Sync folder...</strong> or <strong>Import folder...</strong> to begin syncing or importing the files</body></html>");
            this.btnStartFilesync.requestFocus();
        }
    }

    protected void onStartServerOperation(boolean isUpload) {
        Integer idDestinationFolder;
        String documentId;
        if (this.document.isUploadRunning()) {
            this.document.startUpload(null, isUpload);
            return;
        }
        if (!this.application.isValidConfiguration()) {
            JOptionPane.showMessageDialog(this.frmDocumentsBulkUpload, "Please specify the required application settings before uploading files", "Incomplete application settings", 0);
            this.displayAuthInfoDialog(false);
            return;
        }
        FolderMappingsManager mappingsManager = this.application.getMappingsManager();
        Optional<FolderMapping> optFolderMapping = mappingsManager.getFolderMapping(this.document.getSelectedFolder().getAbsolutePath());
        String targetFolderProposal = "";
        if (optFolderMapping.isPresent()) {
            targetFolderProposal = optFolderMapping.get().getDocumentsFolderKey();
        }
        if ((documentId = JOptionPane.showInputDialog(this.frmDocumentsBulkUpload, "Please specify the Key (document number) of the folder where the files will be " + (isUpload ? "uploaded" : "synced") + ".", targetFolderProposal)) == null) {
            return;
        }
        if (StringUtils.isEmpty((String)documentId)) {
            JOptionPane.showMessageDialog(this.frmDocumentsBulkUpload, "Please specify a numeric value that represents the Key of the folder where the files will be" + (isUpload ? "uploaded" : "synced") + ".", "Validation error", 0);
            return;
        }
        try {
            idDestinationFolder = Integer.parseInt(documentId);
        }
        catch (NumberFormatException nfe) {
            JOptionPane.showMessageDialog(this.frmDocumentsBulkUpload, "The specified Key must be a numeric value.", "Error", 0);
            return;
        }
        GetUploadInformationTask task = new GetUploadInformationTask(idDestinationFolder, isUpload);
        Thread thread = new Thread(task);
        thread.start();
    }

    protected void handleServerInformation(DocumentInfoBean destinationFolderInfo, boolean mayUploadDocuments, String validLicenseMessage, Long maximumUploadSize, String uploadApiVersion, boolean isUpload) throws InvocationTargetException, InterruptedException {
        FolderMapping mapping;
        if (!destinationFolderInfo.isDocumentExists()) {
            SwingUtilities.invokeAndWait(() -> JOptionPane.showMessageDialog(this.frmDocumentsBulkUpload, "A folder with the specified Key {" + destinationFolderInfo.getDocumentId() + "} does not exist.", "Information", 0));
            return;
        }
        if (destinationFolderInfo.getType() != 1 && destinationFolderInfo.getType() != 0) {
            SwingUtilities.invokeAndWait(() -> JOptionPane.showMessageDialog(this.frmDocumentsBulkUpload, "The document with the specified Key {" + destinationFolderInfo.getDocumentId() + "} is not a folder.", "Information", 0));
            return;
        }
        if (!mayUploadDocuments) {
            SwingUtilities.invokeAndWait(() -> JOptionPane.showMessageDialog(this.frmDocumentsBulkUpload, "You do not have the necessary permissions to upload files into the specified folder. Please contact your JIRA administrator.", "Information", 0));
            return;
        }
        boolean askTargetConfirmation = false;
        FolderMappingsManager mappingsManager = this.application.getMappingsManager();
        Optional<FolderMapping> optFolderMapping = mappingsManager.getFolderMapping(this.document.getSelectedFolder().getAbsolutePath());
        askTargetConfirmation = optFolderMapping.isPresent() ? (mapping = optFolderMapping.get()).getDocumentsFolderKey() == null || !mapping.getDocumentsFolderKey().equals(destinationFolderInfo.getDocumentId().toString()) : true;
        if (askTargetConfirmation) {
            String operationName = isUpload ? "uploaded" : "synced";
            String confirmationMessage = "<html><body><p>Files will be " + operationName + " to the folder named <strong>" + destinationFolderInfo.getName() + "</strong> with document Key <strong>" + destinationFolderInfo.getDocumentId() + "</strong>. <br/>The folder belongs to the project <strong>" + destinationFolderInfo.getJiraProjectName() + "</strong>.</p><p>If this information is correct, press OK to begin " + (isUpload ? "uploading" : "syncing") + " the files.</p>";
            int resp = JOptionPane.showConfirmDialog(this.frmDocumentsBulkUpload, confirmationMessage, isUpload ? "Upload" : "Sync confirmation", 2);
            if (resp != 0) {
                return;
            }
        }
        mapping = optFolderMapping.isPresent() ? optFolderMapping.get() : new FolderMapping();
        mapping.setDocumentsFolderKey(destinationFolderInfo.getDocumentId().toString());
        mapping.setPathLocalFolder(this.document.getSelectedFolder().getAbsolutePath());
        mapping.setJiraProjectId(destinationFolderInfo.getJiraProjectId().toString());
        mapping.setJiraProjectName(destinationFolderInfo.getJiraProjectName());
        mapping.setDocumentsFolderName(destinationFolderInfo.getName());
        mapping.setDocumentsFolderKey(destinationFolderInfo.getDocumentId().toString());
        mappingsManager.saveMapping(mapping);
        if (validLicenseMessage != null) {
            SwingUtilities.invokeAndWait(() -> JOptionPane.showMessageDialog(this.frmDocumentsBulkUpload, validLicenseMessage, "Invalid Documents Addon license", 0));
            return;
        }
        int filesCountExceedingMaxSize = this.document.verifyMaximumUploadSize(maximumUploadSize * 1024L * 1024L);
        if (filesCountExceedingMaxSize > 0) {
            String message = "One or more files exceed the maximum size of " + maximumUploadSize + " MB that is allowed for uploading files. Those files will not be uploaded.\nTo increase the upload limit, please contact your JIRA administrator.";
            SwingUtilities.invokeAndWait(() -> JOptionPane.showMessageDialog(this.frmDocumentsBulkUpload, message, "Info", 1));
        }
        this.document.startUpload(destinationFolderInfo.getDocumentId(), isUpload);
    }

    public void displayAuthInfoDialog(boolean invalidCredentials) {
        JiraAuthInfoDialog dlg = new JiraAuthInfoDialog((Frame)this.frmDocumentsBulkUpload, this.application);
        dlg.setUsername(this.application.getUsername());
        dlg.setPassword(this.application.getPassword());
        dlg.setJiraBaseUrl(this.application.getJiraBaseUrl());
        dlg.setIgnoreSSLCertificateErrors(this.application.ignoreSSLCertificateErrors());
        dlg.setLocationRelativeTo(this.frmDocumentsBulkUpload);
        dlg.setInvalidCredentials(invalidCredentials);
        dlg.setVisible(true);
    }

    public void displayServerOperationDialog(String message) {
        SwingUtilities.invokeLater(() -> {
            this.serverOpDialog.setMessageForUser(message);
            this.serverOpDialog.setLocationRelativeTo(this.frmDocumentsBulkUpload);
            this.serverOpDialog.setVisible(true);
        });
    }

    public void displayFolderReadingDialog() {
        SwingUtilities.invokeLater(() -> {
            this.folderReadingDialog.setLocationRelativeTo(this.frmDocumentsBulkUpload);
            this.folderReadingDialog.setVisible(true);
        });
    }

    private void onExitApplication() {
        if (this.document.isUploadRunning()) {
            this.displayInfoMessage("There is an upload currently running. Please stop it before exiting the application.");
            return;
        }
        this.application.exit();
    }

    public void displayInfoMessage(String message) {
        SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(this.frmDocumentsBulkUpload, message, "Info", 1));
    }

    public void displayErrorMessage(String message, String title) {
        SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(this.frmDocumentsBulkUpload, message, title, 0));
    }

    public void displayUploadPercentage(int row, int percentage) {
        SwingUtilities.invokeLater(() -> {
            AbstractTableModel model = (AbstractTableModel)this.table.getModel();
            model.fireTableCellUpdated(row, 3);
            this.uploadProgressBar.setValue(percentage);
        });
    }

    public void enableTextInProgressbar(boolean enable) {
        SwingUtilities.invokeLater(() -> this.uploadProgressBar.setStringPainted(enable));
    }

    public void display() {
        SwingUtilities.invokeLater(() -> {
            this.frmDocumentsBulkUpload.setVisible(true);
            this.frmDocumentsBulkUpload.setLocationRelativeTo(null);
        });
    }

    public void displayAdditionalFiles(List<FolderItem> listFolderItems) {
        DocumentItemsTableModel model = (DocumentItemsTableModel)this.table.getModel();
        model.addAdditionalFiles(listFolderItems);
    }

    public void displayDocumentItems(List<FolderItem> listFolderItems) {
        this.table.setDefaultRenderer(FolderItem.DocumentItemServerOperationStatus.class, new UploadStatusRenderer());
        this.table.setRowHeight(24);
        DocumentItemsTableModel model = new DocumentItemsTableModel(listFolderItems);
        this.table.setModel(model);
        this.table.getColumnModel().getColumn(0).setCellRenderer(new EtcColumnRenderer());
        this.table.getColumnModel().getColumn(2).setCellRenderer(new EtcColumnRenderer());
        this.table.getColumnModel().getColumn(3).setCellRenderer(new EtcColumnRenderer());
        this.table.getColumnModel().getColumn(5).setCellRenderer(new EtcColumnRenderer());
        this.table.getColumnModel().getColumn(6).setCellRenderer(new EtcColumnRenderer());
        this.table.getColumnModel().getColumn(1).setCellEditor(new DocumentTitleEditor(new JTextField()));
        TableColumn column = null;
        for (int i = 0; i < model.columnNames.length; ++i) {
            column = this.table.getColumnModel().getColumn(i);
            int columnWidth = 100;
            switch (i) {
                case 0: {
                    columnWidth = 10;
                    break;
                }
                case 1: {
                    columnWidth = 200;
                    break;
                }
                case 2: {
                    columnWidth = 350;
                    break;
                }
                case 3: {
                    columnWidth = 50;
                    break;
                }
                case 4: {
                    columnWidth = 75;
                    break;
                }
                case 5: {
                    columnWidth = 40;
                    break;
                }
                case 6: {
                    columnWidth = 150;
                }
            }
            column.setPreferredWidth(columnWidth);
        }
        this.table.setEnabled(true);
    }

    public void updateRow(int rowIndex) {
        SwingUtilities.invokeLater(() -> {
            this.table.setRowSelectionInterval(rowIndex, rowIndex);
            AbstractTableModel model = (AbstractTableModel)this.table.getModel();
            model.fireTableRowsUpdated(rowIndex, rowIndex);
        });
    }

    public void setStatusMessage(String message) {
        SwingUtilities.invokeLater(() -> this.lbStatusBarMessage.setText(message));
    }

    private void hideServerOperationDialog() {
        try {
            SwingUtilities.invokeAndWait(() -> this.serverOpDialog.setVisible(false));
        }
        catch (InterruptedException e) {
            log.error("Error hiding server operation dialog", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            log.error("Error hiding server operation dialog", (Throwable)e);
        }
    }

    public void hideFolderReadingDialog() {
        SwingUtilities.invokeLater(() -> this.folderReadingDialog.setVisible(false));
    }

    public void setCurrentFilename(String filename) {
        SwingUtilities.invokeLater(() -> this.lbCurrentFilename.setText(filename));
    }

    public void setGUIStateForUploading() {
        SwingUtilities.invokeLater(() -> {
            this.actionOpenFolder.setEnabled(false);
            this.actionStartUpload.setEnabled(false);
            this.actionStartFilesync.setEnabled(false);
            this.actionPauseUpload.setEnabled(true);
            this.actionStopUpload.setEnabled(true);
            this.actionExitApplication.setEnabled(false);
            this.actionDisplayAuthInfo.setEnabled(false);
            this.actionStartUpload.displayAsStartButton();
            this.actionStartFilesync.displayAsStartButton();
            this.actionAddFiles.setEnabled(false);
            this.actionRemoveFiles.setEnabled(false);
            this.actionEditDocumentName.setEnabled(false);
            this.uploadProgressBar.setVisible(true);
        });
    }

    public void setGUIStateForFilesync() {
        SwingUtilities.invokeLater(() -> {
            this.actionOpenFolder.setEnabled(false);
            this.actionStartUpload.setEnabled(false);
            this.actionStartFilesync.setEnabled(false);
            this.actionPauseUpload.setEnabled(true);
            this.actionStopUpload.setEnabled(true);
            this.actionExitApplication.setEnabled(false);
            this.actionDisplayAuthInfo.setEnabled(false);
            this.actionStartUpload.displayAsStartButton();
            this.actionStartFilesync.displayAsStartButton();
            this.actionAddFiles.setEnabled(false);
            this.actionRemoveFiles.setEnabled(false);
            this.actionEditDocumentName.setEnabled(false);
            this.uploadProgressBar.setVisible(true);
        });
    }

    public void setGUIStateForPaused() {
        SwingUtilities.invokeLater(() -> {
            this.actionOpenFolder.setEnabled(false);
            this.actionStartUpload.setEnabled(true);
            this.actionPauseUpload.setEnabled(false);
            this.actionStopUpload.setEnabled(true);
            this.actionExitApplication.setEnabled(false);
            this.actionDisplayAuthInfo.setEnabled(false);
            this.setStatusMessage("Upload paused");
            this.actionStartUpload.displayAsResumeButton();
            this.actionAddFiles.setEnabled(false);
            this.actionRemoveFiles.setEnabled(false);
            this.actionEditDocumentName.setEnabled(true);
            this.btnStartUpload.requestFocus();
            this.uploadProgressBar.setVisible(false);
        });
    }

    public void setGUIStateForStopped() {
        SwingUtilities.invokeLater(() -> {
            this.actionOpenFolder.setEnabled(true);
            this.actionStartUpload.setEnabled(false);
            this.actionPauseUpload.setEnabled(false);
            this.actionStopUpload.setEnabled(false);
            this.actionExitApplication.setEnabled(true);
            this.actionDisplayAuthInfo.setEnabled(true);
            this.actionStartUpload.displayAsStartButton();
            this.actionAddFiles.setEnabled(false);
            this.actionRemoveFiles.setEnabled(false);
            this.actionEditDocumentName.setEnabled(false);
            this.table.setEnabled(false);
            this.table.clearSelection();
            this.uploadProgressBar.setVisible(false);
        });
    }

    public void enableStartServerOperation(boolean enabled) {
        SwingUtilities.invokeLater(() -> {
            this.actionStartUpload.setEnabled(enabled);
            this.actionStartFilesync.setEnabled(enabled);
        });
    }

    public void enablePauseUpload(boolean enabled) {
        SwingUtilities.invokeLater(() -> this.actionPauseUpload.setEnabled(enabled));
    }

    public void displayUploadProgressBar(boolean display) {
        SwingUtilities.invokeLater(() -> this.uploadProgressBar.setVisible(display));
    }

    public void enableStopUpload(boolean enabled) {
        SwingUtilities.invokeLater(() -> this.actionStopUpload.setEnabled(enabled));
    }

    public void enableFileOperations(boolean enabled) {
        SwingUtilities.invokeLater(() -> {
            this.actionAddFiles.setEnabled(enabled);
            this.actionRemoveFiles.setEnabled(enabled);
            this.actionEditDocumentName.setEnabled(enabled);
        });
    }

    public void displaySyncReport(List<FolderItem> listItems) {
        SwingUtilities.invokeLater(() -> {
            SyncReportDialog dlg = new SyncReportDialog(this.frmDocumentsBulkUpload);
            dlg.setVisible(true);
            dlg.displayReport(listItems);
            dlg.setLocationRelativeTo(this.frmDocumentsBulkUpload);
        });
    }

    private class ActionOpenFolder
    extends AbstractAction {
        public ActionOpenFolder() {
            this.putValue("Name", "Select folder...");
            this.putValue("ShortDescription", "Displays a dialog box that allows choosing a folder for uploading files");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MainWindow.this.onOpenFolder();
        }
    }

    private class ActionAbout
    extends AbstractAction {
        public ActionAbout() {
            this.putValue("Name", "About");
            this.putValue("ShortDescription", "About this application");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AboutDialog dlg = new AboutDialog(MainWindow.this.frmDocumentsBulkUpload);
            dlg.setDefaultCloseOperation(2);
            dlg.setVisible(true);
            dlg.setLocationRelativeTo(MainWindow.this.frmDocumentsBulkUpload);
        }
    }

    private class ActionExitApplication
    extends AbstractAction {
        public ActionExitApplication() {
            this.putValue("Name", "Exit");
            this.putValue("ShortDescription", "Quits the application");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MainWindow.this.onExitApplication();
        }
    }

    private class ActionStartUpload
    extends AbstractAction {
        public ActionStartUpload() {
            this.displayAsStartButton();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MainWindow.this.onStartServerOperation(true);
        }

        public void displayAsStartButton() {
            this.putValue("Name", "Import folder...");
            this.putValue("ShortDescription", "Starts importing the files");
        }

        public void displayAsResumeButton() {
            this.putValue("Name", "Resume import");
            this.putValue("ShortDescription", "Continues the import process");
        }
    }

    private class ActionStartFilesync
    extends AbstractAction {
        public ActionStartFilesync() {
            this.displayAsStartButton();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MainWindow.this.onStartServerOperation(false);
        }

        public void displayAsStartButton() {
            this.putValue("Name", "Sync folder...");
            this.putValue("ShortDescription", "Starts the one way synchronization of the folder to Jira");
        }

        public void displayAsResumeButton() {
            this.putValue("Name", "Resume sync");
            this.putValue("ShortDescription", "Continues the sync process");
        }
    }

    private class ActionPauseServerOperation
    extends AbstractAction {
        public ActionPauseServerOperation() {
            this.putValue("Name", "Pause");
            this.putValue("ShortDescription", "Pauses the sync/import process.");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MainWindow.this.document.pauseUpload();
        }
    }

    private class ActionStopServerOperation
    extends AbstractAction {
        public ActionStopServerOperation() {
            this.putValue("Name", "Stop");
            this.putValue("ShortDescription", "Stops the sync/import process. It cannot be resumed later.");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int resp = JOptionPane.showConfirmDialog(MainWindow.this.frmDocumentsBulkUpload, "Are you sure you want to stop the sync/import?", "Action confirmation", 0);
            if (resp != 0) {
                return;
            }
            MainWindow.this.document.stopUpload();
        }
    }

    private class ActionDisplayAuthInfo
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public ActionDisplayAuthInfo() {
            this.putValue("Name", "Edit authentication information");
            this.putValue("ShortDescription", "Displays a dialog box that allows specifying and validating the authentication information used to upload the files");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MainWindow.this.displayAuthInfoDialog(false);
        }
    }

    private class ActionAddAdditionalFiles
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public ActionAddAdditionalFiles() {
            this.putValue("Name", "Add file(s)");
            this.putValue("ShortDescription", "Allows you to select additional files that will be uploaded");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MainWindow.this.onAddAditionalFiles();
        }
    }

    private class ActionRemoveFiles
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public ActionRemoveFiles() {
            this.putValue("Name", "Remove file(s)");
            this.putValue("ShortDescription", "Allows you to remove specific items from the list of files that will be uploaded");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MainWindow.this.onRemoveFiles();
        }
    }

    private class ActionEditDocumentName
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public ActionEditDocumentName() {
            this.putValue("Name", "Edit document title");
            this.putValue("ShortDescription", "Allows you to specify the Document title that will be used for the file to be uploaded");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MainWindow.this.onEditDocumentName();
        }
    }

    class DocumentItemsTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        public String[] columnNames = new String[]{" ", "Document title", "File name", "File size", "Upload status", "Key", "Full path"};
        private List<FolderItem> listFolderItems;

        public DocumentItemsTableModel(List<FolderItem> listFolderItems) {
            this.listFolderItems = listFolderItems;
        }

        FolderItem getItemAtRowIndex(int rowIndex) {
            return this.listFolderItems.get(rowIndex);
        }

        @Override
        public int getRowCount() {
            return this.listFolderItems.size();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            FolderItem item;
            if (columnIndex != 1) {
                return false;
            }
            return (MainWindow.this.document.getServerOperationStatus() == Document.ServerOperationStatus.IDLE || MainWindow.this.document.getServerOperationStatus() == Document.ServerOperationStatus.PAUSED) && (item = this.listFolderItems.get(rowIndex)).getServerOperationStatus() == FolderItem.DocumentItemServerOperationStatus.PENDING;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 4) {
                return FolderItem.DocumentItemServerOperationStatus.class;
            }
            return String.class;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Object result = null;
            FolderItem item = this.listFolderItems.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    result = new Integer(rowIndex + 1);
                    break;
                }
                case 1: {
                    result = item.getDocumentTitle();
                    break;
                }
                case 2: {
                    result = item.getDisplayRelativePath();
                    break;
                }
                case 3: {
                    result = this.formatFileSize(item.getFileToUpload().length());
                    break;
                }
                case 4: {
                    result = item.getServerOperationStatus();
                    break;
                }
                case 5: {
                    String documentKey = item.getUploadedDocumentKey();
                    if (documentKey != null) {
                        result = documentKey;
                        break;
                    }
                    result = "";
                    break;
                }
                case 6: {
                    result = item.getFileToUpload().getAbsolutePath();
                }
            }
            return result;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 1) {
                FolderItem item = this.listFolderItems.get(rowIndex);
                item.setDocumentTitle((String)aValue);
            }
        }

        public void addAdditionalFiles(List<FolderItem> listItems) {
            int previousLength = this.listFolderItems.size() - listItems.size();
            this.fireTableRowsInserted(previousLength, this.listFolderItems.size() - 1);
        }

        public String formatFileSize(long size) {
            if (size <= 0L) {
                return "0 B";
            }
            String[] units = new String[]{"B", "KB", "MB", "GB", "TB"};
            int digitGroups = (int)(Math.log10(size) / Math.log10(1024.0));
            return new DecimalFormat("#,##0.#").format((double)size / Math.pow(1024.0, digitGroups)) + " " + units[digitGroups];
        }
    }

    private class GetUploadInformationTask
    implements Runnable {
        private final Integer idDestinationFolder;
        private final boolean isUpload;

        public GetUploadInformationTask(Integer idDestinationFolder, boolean isUpload) {
            this.idDestinationFolder = idDestinationFolder;
            this.isUpload = isUpload;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            MainWindow.this.displayServerOperationDialog("Requesting server data... please wait");
            try {
                Thread.sleep(250L);
                String uploadAPIVersion = MainWindow.this.application.getUploadApiVersion();
                if (uploadAPIVersion.equals("2.0")) {
                    DocumentInfoBean destinationFolderInfo = MainWindow.this.application.getDocumentInfo("" + this.idDestinationFolder);
                    boolean tmpMayUploadDocuments = false;
                    if (destinationFolderInfo.isDocumentExists()) {
                        tmpMayUploadDocuments = MainWindow.this.application.checkUploadRights("" + this.idDestinationFolder);
                    }
                    boolean mayUploadDocuments = tmpMayUploadDocuments;
                    String validLicenseMessage = MainWindow.this.application.checkValidDocumentsAddonLicense();
                    Long maximumUploadSize = MainWindow.this.application.getMaximumUploadSize();
                    MainWindow.this.hideServerOperationDialog();
                    MainWindow.this.handleServerInformation(destinationFolderInfo, mayUploadDocuments, validLicenseMessage, maximumUploadSize, uploadAPIVersion, this.isUpload);
                } else {
                    SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(MainWindow.this.frmDocumentsBulkUpload, String.format(MainWindow.ERROR_MESSAGE_API_VERSION_MISMATCH, uploadAPIVersion), "Error", 0));
                }
            }
            catch (ReAuthenticationException rae) {
                log.error("Error re-authenticating", (Throwable)rae);
                SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(MainWindow.this.frmDocumentsBulkUpload, "Error starting the server operation. The server refused the authentication parameters. Please check your login credentials.", "Error", 0));
            }
            catch (SSLException se) {
                log.error("SSL certificate error", (Throwable)se);
                SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(MainWindow.this.frmDocumentsBulkUpload, "The JIRA server's security certificate is not trusted by the Java Runtime Enviroment. To ignore this error, please check the \n'Ignore SSL certificate errors' checkbox in the 'Edit authentication information' screen.\n However, before ignoring these type of errors, please consult with your network administrator", "Error", 0));
            }
            catch (Exception e) {
                log.error("Error starting document upload", (Throwable)e);
                SwingUtilities.invokeLater(() -> JOptionPane.showMessageDialog(MainWindow.this.frmDocumentsBulkUpload, "Error starting the server operation. " + e.getMessage(), "Error", 0));
            }
            finally {
                MainWindow.this.hideServerOperationDialog();
            }
        }
    }

    public class UploadStatusRenderer
    extends JLabel
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        public UploadStatusRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object oStatus, boolean isSelected, boolean hasFocus, int row, int column) {
            FolderItem item = MainWindow.this.document.getDocumentItemAt(row);
            Font currentFont = this.getFont();
            Font boldFont = new Font(currentFont.getName(), 1, currentFont.getSize());
            this.setHorizontalAlignment(0);
            if (item.getServerOperationStatus() != FolderItem.DocumentItemServerOperationStatus.PENDING) {
                this.setFont(boldFont);
            }
            String uploadStatusText = item.getServerOperationStatus().toString();
            Color textColor = new Color(128, 128, 128);
            switch (item.getServerOperationStatus()) {
                case UPLOADING: {
                    textColor = new Color(0, 19, 127);
                    break;
                }
                case SUCCESS_FILE_UPLOADED: 
                case SUCCESS_SYNC_NEW_DOC_CREATED: 
                case SUCCESS_SYNC_NEW_VERSION_CREATED: {
                    textColor = new Color(0, 127, 70);
                    break;
                }
                case ERROR: {
                    textColor = new Color(183, 0, 0);
                    break;
                }
                case IGNORE: 
                case IGNORED: 
                case SYNC_SKIPPED_SERVER_NEVER: 
                case SYNC_SKIPPED_SAME_CONTENTS: 
                case SYNC_SKIPPED_MORE_THAN_ONE_DOCUMENT: {
                    textColor = new Color(224, 187, 0);
                    break;
                }
            }
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setForeground(textColor);
                this.setBackground(table.getBackground());
            }
            this.setText(uploadStatusText);
            return this;
        }
    }

    class EtcColumnRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        EtcColumnRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            hasFocus = false;
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (!isSelected) {
                this.setForeground(new Color(128, 128, 128));
            }
            return c;
        }
    }

    public class DocumentTitleEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = 1L;
        private final Border red;
        private final Border black;
        private JTextField textField;

        public DocumentTitleEditor(JTextField textField) {
            super(textField);
            this.red = new LineBorder(Color.red);
            this.black = new LineBorder(Color.black);
            this.textField = textField;
        }

        @Override
        public boolean stopCellEditing() {
            String documentTitle = this.textField.getText();
            if (StringUtils.isEmpty((String)documentTitle)) {
                MainWindow.this.displayErrorMessage("The specified document title cannot be empty.", "Validation error");
                this.textField.setBorder(this.red);
                return true;
            }
            if (documentTitle.contains("\"")) {
                MainWindow.this.displayErrorMessage("Please do not use double quotation marks in this field.", "Validation error");
                this.textField.setBorder(this.red);
                return true;
            }
            if (documentTitle.contains("'")) {
                MainWindow.this.displayErrorMessage("Please do not use single quotation marks in this field.", "Validation error");
                this.textField.setBorder(this.red);
                return true;
            }
            if (documentTitle.length() > 255) {
                MainWindow.this.displayErrorMessage("The length of the Document title must be less than 255 characters.", "Validation error");
                this.textField.setBorder(this.red);
                return true;
            }
            return super.stopCellEditing();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.textField.setBorder(this.black);
            return super.getTableCellEditorComponent(table, value, isSelected, row, column);
        }
    }

    private class GetDocumentsFolderStructureTask
    implements Callable<String> {
        private GetDocumentsFolderStructureTask() {
        }

        @Override
        public String call() throws Exception {
            return "";
        }
    }
}

