/*
 * Decompiled with CFR 0.152.
 */
package com.stonikbyte.jira.plugins.projectdocs.beans;

import java.io.File;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;

public class FolderItem {
    private File fileToUpload;
    private DocumentItemServerOperationStatus serverOperationStatus;
    private int uploadPercentage;
    private String uploadedDocumentKey;
    private String documentTitle;
    private String relativePath;
    private String displayRelativePath;

    public FolderItem(File fileToUpload) {
        if (fileToUpload.isDirectory()) {
            throw new IllegalArgumentException("Only files can be uploaded.");
        }
        this.fileToUpload = fileToUpload;
        this.serverOperationStatus = DocumentItemServerOperationStatus.PENDING;
        this.documentTitle = FilenameUtils.removeExtension((String)fileToUpload.getName());
    }

    public boolean cleanDocumentTitle() {
        boolean result = false;
        if (this.documentTitle.contains("\"")) {
            result = true;
            this.documentTitle = StringUtils.remove((String)this.documentTitle, (String)"\"");
        }
        if (this.documentTitle.contains("'")) {
            result = true;
            this.documentTitle = StringUtils.remove((String)this.documentTitle, (String)"'");
        }
        return result;
    }

    public void computeDisplayRelativePath(File parentFolder) {
        String pathParentFolder = parentFolder.getAbsolutePath() + File.separator;
        String pathFile = this.fileToUpload.getAbsolutePath();
        String substraction = pathFile.replace(pathParentFolder, "");
        File fileSubstraction = new File(substraction);
        this.displayRelativePath = fileSubstraction.getParent();
        this.displayRelativePath = StringUtils.isEmpty((String)this.displayRelativePath) ? this.fileToUpload.getName() : this.displayRelativePath + File.separator + this.fileToUpload.getName();
    }

    public String getDisplayRelativePath() {
        return this.displayRelativePath;
    }

    public void computeRelativePath(File parentFolder) {
        String pathParentFolder = parentFolder.getAbsolutePath() + File.separator;
        String pathFile = this.fileToUpload.getAbsolutePath();
        String substraction = pathFile.replace(pathParentFolder, "");
        File fileSubstraction = new File(substraction);
        this.relativePath = fileSubstraction.getParent();
    }

    public boolean shortenDocumentTitle() {
        boolean result = false;
        int maxTitleChars = 255;
        if (this.documentTitle.length() > maxTitleChars) {
            this.documentTitle = StringUtils.abbreviate((String)this.documentTitle, (int)maxTitleChars);
        }
        return result;
    }

    public String getDocumentTitle() {
        return this.documentTitle;
    }

    public void setDocumentTitle(String documentTitle) {
        this.documentTitle = documentTitle;
    }

    public int getUploadPercentage() {
        return this.uploadPercentage;
    }

    public void setUploadPercentage(int uploadPercentage) {
        this.uploadPercentage = uploadPercentage;
    }

    public File getFileToUpload() {
        return this.fileToUpload;
    }

    public DocumentItemServerOperationStatus getServerOperationStatus() {
        return this.serverOperationStatus;
    }

    public void setServerOperationStatus(DocumentItemServerOperationStatus uploadStatus) {
        this.serverOperationStatus = uploadStatus;
    }

    public String getUploadedDocumentKey() {
        return this.uploadedDocumentKey;
    }

    public void setUploadedDocumentKey(String uploadedDocumentKey) {
        this.uploadedDocumentKey = uploadedDocumentKey;
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public static enum DocumentItemServerOperationStatus {
        PENDING("Pending", "The file will be processed"),
        UPLOADING("Uploading", "The file is being uploaded to Documents"),
        SUCCESS_FILE_UPLOADED("Upload success", "File successfully uploaded"),
        IGNORE("Ignore", "File will not be uploaded or synced"),
        IGNORED("Ignored", "File was not processed"),
        ERROR("Error", "There was an error processing the file"),
        SYNCING("Syncing", "File is being synced to Documents"),
        SUCCESS_SYNC_NEW_DOC_CREATED("Added", "Sync: new document has been created in Documents"),
        SUCCESS_SYNC_NEW_VERSION_CREATED("Updated", "Sync: new version has been created in Documents"),
        SYNC_SKIPPED_MORE_THAN_ONE_DOCUMENT("Skipped", "Sync: the file was skipped because there were multiple documents with the same name in the target folder"),
        SYNC_SKIPPED_SAME_CONTENTS("Skipped", "Sync: the file was skipped because the local contents is the same with the one on the server"),
        SYNC_SKIPPED_SERVER_NEVER("Skipped", "Sync: the file was skipped because the version on the server is newer than the one being synced");

        final String label;
        final String description;

        private DocumentItemServerOperationStatus(String label, String description) {
            this.label = label;
            this.description = description;
        }

        public String getLabel() {
            return this.label;
        }

        public String getDescription() {
            return this.description;
        }

        public String toString() {
            return this.label;
        }
    }
}

