/*
 * Decompiled with CFR 0.152.
 */
package com.stonikbyte.projectdocs.bulkupload.common.ws;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.engines.RC4Engine;
import org.bouncycastle.crypto.params.KeyParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationSettings {
    private static final Logger log = LoggerFactory.getLogger(ApplicationSettings.class);
    public static final String CHARSET = "UTF-8";
    private String propCountName = null;
    private String configFileName;
    private String personalAccessToken;
    private String jiraBaseUrl;
    private boolean encoded;
    private boolean ignoreSSLCertificateErrors;
    private String basedir;

    public ApplicationSettings(String configFileName) {
        this.configFileName = configFileName;
        this.propCountName = this.countNameBytes("un9ProrVrT/4ww==", "myBytesCount");
    }

    public ApplicationSettings(String configFileName, String basedir) {
        this(configFileName);
        this.basedir = basedir;
    }

    private String countNameBytes(String s, String counter) {
        try {
            byte[] decoded = this.decode(s.getBytes(CHARSET));
            byte[] bytes = this.dString(decoded, counter.getBytes(CHARSET));
            String countedBytes = new String(bytes, CHARSET);
            return countedBytes;
        }
        catch (Exception e) {
            log.error("error", (Throwable)e);
            return "";
        }
    }

    public void readConfiguration() throws Exception {
        Properties prop = new Properties();
        InputStream isPropFile = this.getClass().getResourceAsStream(this.configFileName);
        if (isPropFile == null) {
            File configFile = new File(this.configFileName.replace("/", ""));
            if (!StringUtils.isBlank((String)this.configFileName)) {
                configFile = new File(this.basedir, this.configFileName.replace("/", ""));
                System.out.println("config file path: " + configFile.getAbsolutePath());
            }
            isPropFile = new FileInputStream(configFile);
        }
        prop.load(isPropFile);
        String flagEncoded = prop.getProperty("jira.e.config");
        if (!StringUtils.isEmpty((String)flagEncoded) && flagEncoded.equals("1")) {
            this.encoded = true;
        }
        String readPersonalAccessToken = prop.getProperty("jira.personalAccessToken");
        if (this.encoded) {
            if (!StringUtils.isEmpty((String)readPersonalAccessToken)) {
                byte[] bPersonalAccessToken = this.decode(readPersonalAccessToken.getBytes(CHARSET));
                this.personalAccessToken = new String(this.dString(bPersonalAccessToken, this.getPropsBytes()), CHARSET);
            }
        } else {
            this.personalAccessToken = readPersonalAccessToken;
        }
        this.jiraBaseUrl = prop.getProperty("jira.base.url");
        String sIgnoreSSLCertificateErrors = prop.getProperty("jira.ignore.ssl.certificate.errors");
        if (!StringUtils.isBlank((String)sIgnoreSSLCertificateErrors) && sIgnoreSSLCertificateErrors.equals("1")) {
            this.ignoreSSLCertificateErrors = true;
        }
    }

    private String encode(byte[] digest) {
        return new String(Base64.encodeBase64((byte[])digest));
    }

    private byte[] decode(byte[] data) throws Exception {
        return Base64.decodeBase64((byte[])data);
    }

    public void saveConfiguration() throws IOException, URISyntaxException {
        URL configFilenameUrl = this.getClass().getResource(this.configFileName);
        FileOutputStream os = null;
        if (configFilenameUrl != null) {
            os = new FileOutputStream(new File(configFilenameUrl.toURI()));
        } else {
            File configFile = new File(this.configFileName);
            os = new FileOutputStream(configFile);
        }
        String personalAccessToken = this.personalAccessToken;
        Properties prop = new Properties();
        if (this.encoded) {
            prop.setProperty("jira.e.config", "1");
            personalAccessToken = this.encode(this.eString(personalAccessToken, this.getProps()));
        }
        prop.setProperty("jira.personalAccessToken", personalAccessToken);
        prop.setProperty("jira.base.url", this.jiraBaseUrl);
        if (this.ignoreSSLCertificateErrors) {
            prop.setProperty("jira.ignore.ssl.certificate.errors", "1");
        } else {
            prop.setProperty("jira.ignore.ssl.certificate.errors", "0");
        }
        prop.store(os, "");
        ((OutputStream)os).close();
        log.debug("successfully saved configuration");
    }

    public String getProps() {
        return this.propCountName;
    }

    public byte[] getPropsBytes() throws UnsupportedEncodingException {
        return this.getProps().getBytes(CHARSET);
    }

    public boolean isValidLoginInfo() {
        return !StringUtils.isEmpty((String)this.personalAccessToken) && !StringUtils.isEmpty((String)this.jiraBaseUrl);
    }

    private byte[] dString(byte[] input, byte[] key) {
        RC4Engine cipher = new RC4Engine();
        cipher.init(false, (CipherParameters)new KeyParameter(key));
        byte[] result = new byte[input.length];
        cipher.processBytes(input, 0, input.length, result, 0);
        return result;
    }

    private byte[] eString(String content, String keyString) throws UnsupportedEncodingException {
        RC4Engine cipher = new RC4Engine();
        byte[] input = content.getBytes();
        byte[] key = keyString.getBytes(CHARSET);
        cipher.init(true, (CipherParameters)new KeyParameter(key));
        byte[] result = new byte[input.length];
        cipher.processBytes(input, 0, input.length, result, 0);
        return result;
    }

    public String getConfigFileName() {
        return this.configFileName;
    }

    public void setConfigFileName(String configFileName) {
        this.configFileName = configFileName;
    }

    public String getPersonalAccessToken() {
        return this.personalAccessToken;
    }

    public void setPersonalAccessToken(String personalAccessToken) {
        this.personalAccessToken = personalAccessToken;
    }

    public String getJiraBaseUrl() {
        return this.jiraBaseUrl;
    }

    public synchronized boolean isEncoded() {
        return this.encoded;
    }

    public synchronized void setEncoded(boolean encoded) {
        this.encoded = encoded;
    }

    public void setJiraBaseUrl(String jiraBaseUrl) {
        this.jiraBaseUrl = jiraBaseUrl;
    }

    public boolean isIgnoreSSLCertficateErrors() {
        return this.ignoreSSLCertificateErrors;
    }

    public void setIgnoreSSLCertficateErrors(boolean ignoreSSLCertficateErrors) {
        this.ignoreSSLCertificateErrors = ignoreSSLCertficateErrors;
    }
}

