/*
 * Decompiled with CFR 0.152.
 */
package ro.teodorbaciu.commons.client.ws.progress;

import java.io.IOException;
import java.io.OutputStream;
import ro.teodorbaciu.commons.client.ws.progress.WriteListener;

public class OutputStreamProgress
extends OutputStream {
    private final OutputStream outstream;
    private volatile long bytesWritten = 0L;
    private final WriteListener writeListener;

    public OutputStreamProgress(OutputStream outstream, WriteListener writeListener) {
        this.outstream = outstream;
        this.writeListener = writeListener;
    }

    @Override
    public void write(int b) throws IOException {
        this.outstream.write(b);
        ++this.bytesWritten;
        this.writeListener.registerWrite(this.bytesWritten);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.outstream.write(b);
        this.bytesWritten += (long)b.length;
        this.writeListener.registerWrite(this.bytesWritten);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.outstream.write(b, off, len);
        this.bytesWritten += (long)len;
        this.writeListener.registerWrite(this.bytesWritten);
    }

    @Override
    public void flush() throws IOException {
        this.outstream.flush();
    }

    @Override
    public void close() throws IOException {
        this.outstream.close();
    }
}

